/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.function.Supplier;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.joefoxe.hexerei.client.renderer.entity.render.OwlVariant;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class OwlTeleportParticlePacket {
    Vec3 pos;
    OwlVariant owlVariant;
    ResourceKey<Level> dimension;

    public OwlTeleportParticlePacket(ResourceKey<Level> dimension, Vec3 pos, OwlVariant owlVariant) {
        this.pos = pos;
        this.owlVariant = owlVariant;
        this.dimension = dimension;
    }

    public static void encode(OwlTeleportParticlePacket object, FriendlyByteBuf buffer) {
        buffer.m_236858_(object.dimension);
        buffer.writeDouble(object.pos.f_82479_);
        buffer.writeDouble(object.pos.f_82480_);
        buffer.writeDouble(object.pos.f_82481_);
        buffer.writeInt(object.owlVariant.getId());
    }

    public static OwlTeleportParticlePacket decode(FriendlyByteBuf buffer) {
        return new OwlTeleportParticlePacket((ResourceKey<Level>)buffer.m_236801_(Registries.f_256858_), new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), OwlVariant.byId(buffer.readInt()));
    }

    public static void consume(OwlTeleportParticlePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level world;
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                world = Hexerei.proxy.getLevel();
            } else {
                if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                    return;
                }
                world = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_();
            }
            if (world.m_46472_().equals(packet.dimension)) {
                OwlEntity.teleportParticles(world, packet.pos, packet.owlVariant);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

