/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import website.eccentric.tome.ModName;
import website.eccentric.tome.Tome;
import website.eccentric.tome.events.OpenTomeEvent;

public class TomeItem
extends Item {
    public TomeItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        InteractionHand hand = context.m_43724_();
        BlockPos position = context.m_8083_();
        ItemStack tome = context.m_43722_();
        String mod = ModName.from(context.m_43725_().m_8055_(position));
        Map<String, List<ItemStack>> modsBooks = Tome.getModsBooks(tome);
        if (!player.m_6144_() || !modsBooks.containsKey(mod)) {
            return InteractionResult.PASS;
        }
        List<ItemStack> books = modsBooks.get(mod);
        ItemStack book = books.get(books.size() - 1);
        player.m_21008_(hand, Tome.convert(tome, book));
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack tome = player.m_21120_(hand);
        if (level.f_46443_) {
            MinecraftForge.EVENT_BUS.post((Event)new OpenTomeEvent(tome));
        }
        return InteractionResultHolder.m_19092_((Object)tome, (boolean)level.f_46443_);
    }

    public void m_7373_(ItemStack tome, @Nullable Level level, List<Component> tooltip, TooltipFlag advanced) {
        Map<String, List<ItemStack>> modsBooks = Tome.getModsBooks(tome);
        for (String mod : modsBooks.keySet()) {
            tooltip.add((Component)Component.m_237113_((String)ModName.name(mod)));
            List<ItemStack> books = modsBooks.get(mod);
            for (ItemStack book : books) {
                if (book.m_150930_(Items.f_41852_)) continue;
                String name = book.m_41786_().getString();
                tooltip.add((Component)Component.m_237113_((String)("  " + ChatFormatting.GRAY + name)));
            }
        }
    }
}

