/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.nethervinery.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.satisfy.nethervinery.NetherVinery;
import net.satisfy.nethervinery.effect.GravediggerEffect;
import net.satisfy.nethervinery.effect.HearthstoneEffect;
import net.satisfy.nethervinery.effect.ImprovedGravediggerEffect;
import net.satisfy.nethervinery.effect.ImprovedHearthstoneEffect;
import net.satisfy.nethervinery.effect.NetheriteEffect;
import net.satisfy.nethervinery.util.NetherVineryIdentifier;

public class NetherEffects {
    private static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((String)"nethervinery", (ResourceKey)Registries.f_256929_);
    private static final Registrar<MobEffect> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<MobEffect> GRAVEDIGGER = NetherEffects.registerEffect("gravedigger", GravediggerEffect::new);
    public static final RegistrySupplier<MobEffect> HEARTHSTONE = NetherEffects.registerEffect("hearthstone", HearthstoneEffect::new);
    public static final RegistrySupplier<MobEffect> IMPROVED_GRAVEDIGGER = NetherEffects.registerEffect("improved_gravedigger", ImprovedGravediggerEffect::new);
    public static final RegistrySupplier<MobEffect> IMPROVED_HEARTHSTONE = NetherEffects.registerEffect("improved_hearthstone", ImprovedHearthstoneEffect::new);
    public static final RegistrySupplier<MobEffect> NETHERITE = NetherEffects.registerEffect("netherite", NetheriteEffect::new);

    private static RegistrySupplier<MobEffect> registerEffect(String name, Supplier<MobEffect> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((ResourceLocation)new NetherVineryIdentifier(name), effect);
    }

    public static void init() {
        NetherVinery.LOGGER.debug("Mob effects");
        MOB_EFFECTS.register();
    }
}

