/*
 * Decompiled with CFR 0.152.
 */
package reliquary.data;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import reliquary.init.ModBlocks;
import reliquary.init.ModItems;

public class ChestLootInjectSubProvider
implements LootTableSubProvider {
    protected static final Map<ResourceLocation, ResourceLocation> LOOT_INJECTS = new HashMap<ResourceLocation, ResourceLocation>();
    private static final String INJECT_FOLDER = "inject/";
    public static final ResourceLocation ABANDONED_MINESHAFT = ChestLootInjectSubProvider.registerLootInject(BuiltInLootTables.f_78759_);
    public static final ResourceLocation DESERT_PYRAMID = ChestLootInjectSubProvider.registerLootInject(BuiltInLootTables.f_78764_);
    public static final ResourceLocation END_CITY_TREASURE = ChestLootInjectSubProvider.registerLootInject(BuiltInLootTables.f_78741_);
    public static final ResourceLocation IGLOO_CHEST = ChestLootInjectSubProvider.registerLootInject(BuiltInLootTables.f_78688_);
    public static final ResourceLocation JUNGLE_TEMPLE = ChestLootInjectSubProvider.registerLootInject(BuiltInLootTables.f_78686_);
    public static final ResourceLocation NETHER_BRIDGE = ChestLootInjectSubProvider.registerLootInject(BuiltInLootTables.f_78760_);
    public static final ResourceLocation SIMPLE_DUNGEON = ChestLootInjectSubProvider.registerLootInject(BuiltInLootTables.f_78742_);
    public static final ResourceLocation STRONGHOLD_CORRIDOR = ChestLootInjectSubProvider.registerLootInject(BuiltInLootTables.f_78763_);
    public static final ResourceLocation STRONGHOLD_CROSSING = ChestLootInjectSubProvider.registerLootInject(BuiltInLootTables.f_78762_);
    public static final ResourceLocation STRONGHOLD_LIBRARY = ChestLootInjectSubProvider.registerLootInject(BuiltInLootTables.f_78761_);
    public static final ResourceLocation VILLAGE_WEAPONSMITH = ChestLootInjectSubProvider.registerLootInject(BuiltInLootTables.f_78743_);

    private static ResourceLocation registerLootInject(ResourceLocation vanillaLootTable) {
        return LOOT_INJECTS.computeIfAbsent(vanillaLootTable, k -> new ResourceLocation("reliquary", INJECT_FOLDER + vanillaLootTable.m_135815_()));
    }

    public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> tables) {
        tables.accept(ABANDONED_MINESHAFT, ChestLootInjectSubProvider.getLootTable(61, this.getItemLootEntry((Item)ModItems.RIB_BONE.get(), 10, 2), this.getItemLootEntry((Item)ModItems.SLIME_PEARL.get(), 8, 3), this.getItemLootEntry((Item)ModItems.BAT_WING.get(), 8, 3), this.getItemLootEntry((Item)ModItems.NEBULOUS_HEART.get(), 4, 2), this.getItemLootEntry((Item)ModItems.SQUID_BEAK.get(), 8, 4), this.getItemLootEntry((Item)ModItems.WITCH_HAT.get(), 5, 2), this.getItemLootEntry((Item)ModItems.ANGELIC_FEATHER.get(), 2)));
        tables.accept(DESERT_PYRAMID, ChestLootInjectSubProvider.getLootTable(44, this.getItemLootEntry((Item)ModItems.RIB_BONE.get(), 10, 3), this.getItemLootEntry((Item)ModItems.CHELICERAE.get(), 10, 2), this.getItemLootEntry((Item)ModItems.CATALYZING_GLAND.get(), 8, 4), this.getItemLootEntry((Item)ModItems.ZOMBIE_HEART.get(), 8, 5), this.getItemLootEntry((Item)ModItems.NEBULOUS_HEART.get(), 5, 3), this.getItemLootEntry((Item)ModItems.MOLTEN_CORE.get(), 5, 2), this.getItemLootEntry((Item)ModItems.SQUID_BEAK.get(), 8, 4), this.getItemLootEntry((Item)ModItems.ANGELIC_FEATHER.get(), 2)));
        tables.accept(END_CITY_TREASURE, ChestLootInjectSubProvider.getLootTable(64, this.getItemLootEntry((Item)ModItems.NEBULOUS_HEART.get(), 30, 5), this.getItemLootEntry((Item)ModItems.ENDER_STAFF.get(), 5), this.getItemLootEntry((Item)ModItems.RENDING_GALE.get(), 1)));
        tables.accept(IGLOO_CHEST, ChestLootInjectSubProvider.getLootTable(60, this.getItemLootEntry((Item)ModItems.FROZEN_CORE.get(), 40, 5)));
        tables.accept(JUNGLE_TEMPLE, ChestLootInjectSubProvider.getLootTable(62, this.getItemLootEntry((Item)ModItems.RIB_BONE.get(), 10, 3), this.getItemLootEntry((Item)ModItems.CATALYZING_GLAND.get(), 7, 3), this.getItemLootEntry((Item)ModItems.BAT_WING.get(), 7, 3), this.getItemLootEntry((Item)ModItems.NEBULOUS_HEART.get(), 6, 3), this.getItemLootEntry((Item)ModItems.ANGELIC_FEATHER.get(), 2)));
        tables.accept(NETHER_BRIDGE, ChestLootInjectSubProvider.getLootTable(61, this.getItemLootEntry((Item)ModItems.WITHERED_RIB.get(), 20, 2), this.getItemLootEntry((Item)ModItems.SLIME_PEARL.get(), 8), this.getItemLootEntry((Item)ModItems.MOLTEN_CORE.get(), 8, 2), this.getItemLootEntry((Item)ModItems.VOID_TEAR.get(), 1), this.getItemLootEntry((Item)ModItems.SALAMANDER_EYE.get(), 1), this.getItemLootEntry((Item)ModBlocks.INTERDICTION_TORCH_ITEM.get(), 1)));
        tables.accept(SIMPLE_DUNGEON, ChestLootInjectSubProvider.getLootTable(68, this.getItemLootEntry((Item)ModItems.RIB_BONE.get(), 8, 2), this.getItemLootEntry((Item)ModItems.CHELICERAE.get(), 8, 2), this.getItemLootEntry((Item)ModItems.ZOMBIE_HEART.get(), 8, 2), this.getItemLootEntry((Item)ModItems.WITCH_HAT.get(), 3, 2), this.getItemLootEntry((Item)ModItems.GLOWING_WATER.get(), 5, 2)));
        tables.accept(STRONGHOLD_CORRIDOR, ChestLootInjectSubProvider.getLootTable(64, this.getItemLootEntry((Item)ModItems.RIB_BONE.get(), 7, 3), this.getItemLootEntry((Item)ModItems.SLIME_PEARL.get(), 8, 4), this.getItemLootEntry((Item)ModItems.NEBULOUS_HEART.get(), 8, 4), this.getItemLootEntry((Item)ModItems.FROZEN_CORE.get(), 7, 4), this.getItemLootEntry((Item)ModItems.ANGELHEART_VIAL.get(), 4, 2), this.getItemLootEntry((Item)ModItems.SHEARS_OF_WINTER.get(), 2)));
        tables.accept(STRONGHOLD_CROSSING, ChestLootInjectSubProvider.getLootTable(55, this.getItemLootEntry((Item)ModItems.RIB_BONE.get(), 7, 3), this.getItemLootEntry((Item)ModItems.WITHERED_RIB.get(), 5, 3), this.getItemLootEntry((Item)ModItems.SLIME_PEARL.get(), 9, 3), this.getItemLootEntry((Item)ModItems.NEBULOUS_HEART.get(), 9, 3), this.getItemLootEntry((Item)ModItems.FROZEN_CORE.get(), 7, 3), this.getItemLootEntry((Item)ModItems.ANGELHEART_VIAL.get(), 8, 4)));
        tables.accept(STRONGHOLD_LIBRARY, ChestLootInjectSubProvider.getLootTable(92, this.getItemLootEntry((Item)ModItems.SLIME_PEARL.get(), 8, 4)));
        tables.accept(VILLAGE_WEAPONSMITH, ChestLootInjectSubProvider.getLootTable(78, this.getItemLootEntry((Item)ModItems.ZOMBIE_HEART.get(), 10, 5), this.getItemLootEntry((Item)ModItems.WITCH_HAT.get(), 5, 2), this.getItemLootEntry((Item)ModItems.GLOWING_WATER.get(), 7, 4)));
    }

    private LootPoolEntryContainer.Builder<?> getItemLootEntry(Item item, int weight, int maxCount) {
        return LootItem.m_79579_((ItemLike)item).m_79707_(weight).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)maxCount)));
    }

    private LootPoolEntryContainer.Builder<?> getItemLootEntry(Item item, int weight) {
        return LootItem.m_79579_((ItemLike)item).m_79707_(weight);
    }

    private static LootTable.Builder getLootTable(int emptyWeight, LootPoolEntryContainer.Builder<?> ... entries) {
        LootPool.Builder pool = LootPool.m_79043_().name("main");
        for (LootPoolEntryContainer.Builder<?> entry : entries) {
            pool.m_79076_(entry);
        }
        pool.m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(emptyWeight));
        return LootTable.m_79147_().m_79161_(pool);
    }
}

