/*
 * Decompiled with CFR 0.152.
 */
package satisfy.herbalbrews.forge.mixin;

import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import satisfy.herbalbrews.items.HatItem;
import satisfy.herbalbrews.registry.HatRegistry;

@Mixin(value={HatItem.class})
public abstract class HatItemMixin
extends ArmorItem {
    @Shadow
    @Final
    private ResourceLocation hatTexture;

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public Model getGenericArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return HatRegistry.getHatModel(itemStack.m_41720_(), original.m_5585_());
            }
        });
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return this.hatTexture.toString();
    }

    private HatItemMixin(ArmorMaterial arg, ArmorItem.Type arg2, Item.Properties arg3) {
        super(arg, arg2, arg3);
    }
}

