/*
 * Decompiled with CFR 0.152.
 */
package com.jocosero.kakapos.entity.client;

import com.jocosero.kakapos.entity.animations.KakapoAnimationDefinitions;
import com.jocosero.kakapos.entity.custom.KakapoEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;

public class KakapoModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart kakapo;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart torso;
    private final ModelPart tail;
    private final ModelPart wing_right;
    private final ModelPart wing_left;
    private final ModelPart leg_left;
    private final ModelPart leg_right;

    public KakapoModel(ModelPart root) {
        this.kakapo = root.m_171324_("kakapo");
        this.head = this.kakapo.m_171324_("head");
        this.body = this.kakapo.m_171324_("body");
        this.torso = this.kakapo.m_171324_("body").m_171324_("torso");
        this.tail = this.kakapo.m_171324_("body").m_171324_("torso").m_171324_("tail");
        this.wing_right = this.kakapo.m_171324_("body").m_171324_("torso").m_171324_("wing_right");
        this.wing_left = this.kakapo.m_171324_("body").m_171324_("torso").m_171324_("wing_left");
        this.leg_left = this.kakapo.m_171324_("body").m_171324_("leg_left");
        this.leg_right = this.kakapo.m_171324_("body").m_171324_("leg_right");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition kakapo = partdefinition.m_171599_("kakapo", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)17.5f, (float)-0.25f));
        PartDefinition head = kakapo.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(17, 17).m_171488_(-2.5f, -1.0f, -4.0f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(25, 0).m_171488_(-2.0f, -3.0f, -4.0f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 6).m_171488_(-1.0f, -1.0f, -5.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-4.0f));
        PartDefinition body = kakapo.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-0.5f, (float)-4.5f, (float)-2.75f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, -3.0f, -5.0f, 7.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)3.5f, (float)5.0f));
        PartDefinition tail = torso.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(13, 26).m_171488_(-2.5f, 0.0f, 0.0f, 5.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(28, 29).m_171488_(-2.5f, 0.0f, 4.0f, 5.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)5.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition wing_right = torso.m_171599_("wing_right", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.5f, (float)-2.5f, (float)-3.25f));
        PartDefinition wing_r1 = wing_right.m_171599_("wing_r1", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171480_().m_171488_(-1.0f, 0.5f, 0.0f, 1.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-0.75f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition wing_left = torso.m_171599_("wing_left", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.5f, (float)-2.5f, (float)-3.25f));
        PartDefinition wing_r2 = wing_left.m_171599_("wing_r2", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(0.0f, 0.5f, 0.0f, 1.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-0.75f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition leg_left = body.m_171599_("leg_left", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)6.0f, (float)8.0f));
        PartDefinition leg_r1 = leg_left.m_171599_("leg_r1", CubeListBuilder.m_171558_().m_171514_(9, 17).m_171488_(0.5f, 2.35f, -3.0f, 2.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(13, 18).m_171480_().m_171488_(0.5f, 1.35f, -1.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 0).m_171480_().m_171488_(0.0f, -0.65f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition leg_right = body.m_171599_("leg_right", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)6.0f, (float)8.0f));
        PartDefinition leg_r2 = leg_right.m_171599_("leg_r2", CubeListBuilder.m_171558_().m_171514_(9, 17).m_171480_().m_171488_(-3.5f, 2.35f, -3.0f, 2.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(13, 18).m_171488_(-2.5f, 1.35f, -1.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-3.0f, -0.65f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_267799_(KakapoAnimationDefinitions.KAKAPO_WALK, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.m_233385_(((KakapoEntity)((Object)entity)).idleAnimationState, KakapoAnimationDefinitions.KAKAPO_IDLE, ageInTicks, 1.0f);
        this.m_233385_(((KakapoEntity)((Object)entity)).danceAnimationState, KakapoAnimationDefinitions.KAKAPO_DANCE, ageInTicks, 1.0f);
        this.m_233385_(((KakapoEntity)((Object)entity)).sitAnimationState, KakapoAnimationDefinitions.KAKAPO_SIT, ageInTicks, 1.0f);
        this.m_233385_(((KakapoEntity)((Object)entity)).preenAnimationState, KakapoAnimationDefinitions.KAKAPO_PREEN, ageInTicks, 1.0f);
        this.m_233385_(((KakapoEntity)((Object)entity)).fallAnimationState, KakapoAnimationDefinitions.KAKAPO_FALL, ageInTicks, 1.0f);
        this.m_233385_(((KakapoEntity)((Object)entity)).runAnimationState, KakapoAnimationDefinitions.KAKAPO_RUN, ageInTicks, 1.0f);
        this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.head.f_104203_ = headPitch / 57.295776f;
        this.wing_right.f_104204_ = -0.3f * limbSwingAmount;
        this.wing_left.f_104204_ = 0.3f * limbSwingAmount;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.kakapo.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.kakapo;
    }
}

