/*
 * Decompiled with CFR 0.152.
 */
package com.jocosero.kakapos.entity.custom;

import com.jocosero.kakapos.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class KakapoEntity
extends ShoulderRidingEntity {
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42410_, Items.f_42619_, Items.f_42436_});
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState danceAnimationState = new AnimationState();
    public final AnimationState sitAnimationState = new AnimationState();
    public final AnimationState preenAnimationState = new AnimationState();
    public final AnimationState fallAnimationState = new AnimationState();
    public final AnimationState runAnimationState = new AnimationState();
    private boolean partyParrot;
    @Nullable
    private BlockPos jukebox;
    private int idleAnimationTimeout = 0;
    private int fallAnimationTimeout = 0;
    private int preenAnimationTimeout = this.f_19796_.m_188503_(11) + 10;
    private double lastTickPosX;
    private double lastTickPosY;
    private double lastTickPosZ;

    public KakapoEntity(EntityType<? extends ShoulderRidingEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, (double)0.15f).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.8));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(1, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.7, 3.0f, 1.0f, false));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 5.0f));
    }

    public void m_8107_() {
        Entity entity;
        this.lastTickPosX = this.m_20185_();
        this.lastTickPosY = this.m_20186_();
        this.lastTickPosZ = this.m_20189_();
        if (this.jukebox == null || !this.jukebox.m_203195_((Position)this.m_20182_(), 3.46) || !this.m_9236_().m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
            this.partyParrot = false;
            this.jukebox = null;
        }
        if (this.partyParrot) {
            this.danceAnimationState.m_216982_(this.f_19797_);
        } else {
            this.danceAnimationState.m_216973_();
        }
        super.m_8107_();
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.8, 1.0));
        }
        if (this.m_20159_() && !this.m_21827_() && (entity = this.m_20202_()) instanceof Player) {
            Player player = (Player)entity;
            this.m_21557_(false);
            if (this.shouldStopRiding(player)) {
                this.m_146884_(player.m_20182_());
                this.m_8127_();
            }
        }
        if (this.m_21825_()) {
            this.sitAnimationState.m_216977_(this.f_19797_);
        } else {
            this.sitAnimationState.m_216973_();
        }
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
            this.setupFallAnimationState();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216982_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    private void setupFallAnimationState() {
        if (!this.m_20096_()) {
            ++this.fallAnimationTimeout;
            if (this.fallAnimationTimeout >= 10) {
                this.fallAnimationState.m_216982_(this.f_19797_);
            }
        } else {
            this.fallAnimationTimeout = 0;
            this.fallAnimationState.m_216973_();
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING && this.isMoving() ? Math.min(pPartialTick + 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    private boolean isMoving() {
        double dz;
        double dy;
        double dx = this.m_20185_() - this.lastTickPosX;
        return dx * dx + (dy = this.m_20186_() - this.lastTickPosY) * dy + (dz = this.m_20189_() - this.lastTickPosZ) * dz > 0.001;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (!this.m_21824_() && FOOD_ITEMS.test(itemstack)) {
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12190_, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
            }
            if (!this.m_9236_().f_46443_) {
                if (this.f_19796_.m_188503_(10) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)pPlayer)) {
                    this.m_21828_(pPlayer);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)pPlayer)) {
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            if (!this.m_9236_().f_46443_) {
                this.m_21839_(!this.m_21827_());
                return super.m_6071_(pPlayer, pHand);
            }
            return InteractionResult.m_19078_((boolean)true);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public void m_6034_(double p_20210_, double p_20211_, double p_20212_) {
        if (this.m_20159_()) {
            if (this.m_21255_()) {
                p_20211_ += 1.0;
            }
            p_20211_ += 0.38;
        }
        super.m_6034_(p_20210_, p_20211_, p_20212_);
    }

    public boolean m_6898_(ItemStack pStack) {
        return FOOD_ITEMS.test(pStack);
    }

    public void m_6818_(BlockPos pPos, boolean pIsPartying) {
        this.jukebox = pPos;
        this.partyParrot = pIsPartying;
    }

    public boolean isPartyParrot() {
        return this.partyParrot;
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_7324_(Entity pEntity) {
        if (!(pEntity instanceof Player)) {
            super.m_7324_(pEntity);
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.isMoving()) {
            this.runAnimationState.m_216977_(this.f_19797_);
        } else {
            this.runAnimationState.m_216973_();
        }
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21839_(false);
        }
        return super.m_6469_(pSource, pAmount);
    }

    private boolean shouldStopRiding(Player player) {
        return player.m_6047_() || player.isInFluidType() || player.m_5833_() || player.m_5803_();
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.KAKAPO_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.KAKAPO_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.KAKAPO_DEATH.get();
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 0.8f);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }
}

