/*
 * Decompiled with CFR 0.152.
 */
package com.cyvack.crystal_clear.common.generation;

import com.cyvack.crystal_clear.RegistrationGenPlatform;
import com.cyvack.crystal_clear.common.CrystalClear;
import com.cyvack.crystal_clear.common.content.blocks.GlassCasing;
import com.cyvack.crystal_clear.common.content.blocks.GlassEncasedCogwheel;
import com.cyvack.crystal_clear.common.content.blocks.GlassEncasedShaft;
import com.cyvack.crystal_clear.common.creative_tab.ItemVisibilityHandler;
import com.cyvack.crystal_clear.common.glass_ct_behaviours.GlassEncasedCTBehaviour;
import com.cyvack.crystal_clear.common.glass_ct_behaviours.GlassEncasedCogCTBehaviour;
import com.cyvack.crystal_clear.common.registry.CCCBlocks;
import com.cyvack.crystal_clear.common.registry.CCSpriteShifts;
import com.cyvack.crystal_clear.common.util.CasingHolder;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.content.decoration.MetalScaffoldingBlock;
import com.simibubi.create.content.decoration.MetalScaffoldingCTBehaviour;
import com.simibubi.create.content.decoration.palettes.AllPaletteBlocks;
import com.simibubi.create.content.kinetics.BlockStressDefaults;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.block.connected.SimpleCTBehaviour;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.TagGen;
import com.simibubi.create.foundation.utility.Couple;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class RegistrateGenHelper {
    public static <T extends AbstractRegistrate<?>> BlockEntry<GlassCasing> glassCasing(T reg, CasingHolder holder, boolean clear) {
        String name = holder.name();
        String newName = !clear ? name + "_glass_casing" : name + "_clear_glass_casing";
        CTSpriteShiftEntry ctEntry = CCSpriteShifts.GLASS_CASING_SHIFTS.get(name).get(clear);
        return ((BlockBuilder)((BlockBuilder)reg.block(newName, GlassCasing::new).initialProperties(() -> Blocks.f_50058_).properties(p -> p.m_60918_(SoundType.f_56744_)).properties(BlockBehaviour.Properties::m_60955_).properties(RegistrateGenHelper::glassProperties).addLayer(() -> RenderType::m_110463_).blockstate((c, p) -> p.simpleBlock((Block)c.get())).onRegister(CreateRegistrate.connectedTextures(() -> new SimpleCTBehaviour(ctEntry)))).tag(new TagKey[]{AllTags.AllBlockTags.CASING.tag}).recipe((c, p) -> ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)c.get())).m_126209_((ItemLike)(clear ? CCCBlocks.GLASS_CASINGS.getCasing(holder.name()) : (ItemLike)holder.casing().get())).m_126209_((ItemLike)AllPaletteBlocks.FRAMED_GLASS).m_126132_("has_valve", (CriterionTriggerInstance)RegistrateRecipeProvider.has((TagKey)AllTags.AllItemTags.CASING.tag)).m_126140_((Consumer)p, CrystalClear.path("crafting/glass_casing/" + c.getName()))).item().tag(new TagKey[]{AllTags.AllItemTags.CASING.tag}).build()).register();
    }

    public static <T extends AbstractRegistrate<T>> BlockEntry<MetalScaffoldingBlock> glassScaffolding(T reg, String modId, String casing, boolean clear, CTSpriteShiftEntry side, CTSpriteShiftEntry innerSide, Supplier<ItemLike> scaffolding, NonNullFunction<BlockBehaviour.Properties, MetalScaffoldingBlock> factory) {
        String name = casing.concat(clear ? "_clear" : "").concat("_glass_scaffolding");
        CTSpriteShiftEntry mainShift = CCSpriteShifts.GLASS_CASING_SHIFTS.get(casing).get(clear);
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)reg.block(name, factory).initialProperties(() -> Blocks.f_50616_).properties(p -> p.m_60918_(SoundType.f_154663_)).addLayer(() -> RenderType::m_110463_).onRegister(CreateRegistrate.connectedTextures(() -> new MetalScaffoldingCTBehaviour(side, innerSide, mainShift)))).transform(TagGen.pickaxeOnly())).tag(new TagKey[]{BlockTags.f_13082_}).recipe((c, p) -> ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)c.get())).m_126209_((ItemLike)scaffolding.get()).m_126209_((ItemLike)AllPaletteBlocks.FRAMED_GLASS).m_126132_("has_valve", (CriterionTriggerInstance)RegistrateRecipeProvider.has((TagKey)AllTags.AllItemTags.CASING.tag)).m_126140_((Consumer)p, CrystalClear.path("crafting/glass_scaffolding/" + c.getName()))).transform(RegistrationGenPlatform.glassScaffolding(modId, casing, clear, RegistrateGenHelper.getGlassScaffoldingHolder(modId, casing, clear)))).register();
    }

    private static IDArrayHolder<ResourceLocation> getGlassScaffoldingHolder(String modId, String casing, boolean clear) {
        IDArrayHolder<ResourceLocation> holder = new IDArrayHolder<ResourceLocation>(new HashMap());
        holder.add("main", new ResourceLocation(modId, "block/scaffold/block"));
        holder.add("casing", new ResourceLocation(modId, "block/".concat(casing).concat(clear ? "_clear" : "").concat("_glass_casing")));
        String scaffoldingFolder = "block/scaffold/";
        if (casing.contentEquals("andesite") || casing.contentEquals("brass") || casing.contentEquals("copper")) {
            holder.add("top", Create.asResource((String)("block/funnel/" + casing + "_funnel_frame")));
            holder.add("inside", Create.asResource((String)(scaffoldingFolder + casing + "_scaffold_inside")));
            holder.add("side", Create.asResource((String)(scaffoldingFolder + casing + "_scaffold")));
            holder.add("particle", Create.asResource((String)(scaffoldingFolder + casing + "_scaffold")));
        } else {
            holder.add("top", new ResourceLocation(modId, scaffoldingFolder + casing + "_frame"));
            holder.add("inside", new ResourceLocation(modId, scaffoldingFolder + casing + "_scaffold_inside"));
            holder.add("side", new ResourceLocation(modId, scaffoldingFolder + casing + "_scaffold"));
            holder.add("particle", new ResourceLocation(modId, scaffoldingFolder + casing + "_scaffold"));
        }
        return holder;
    }

    public static <T extends AbstractRegistrate<T>> BlockEntry<GlassEncasedShaft> glassEncasedShaft(T reg, String modId, String casing, Boolean clear, NonNullFunction<BlockBehaviour.Properties, GlassEncasedShaft> factory) {
        String newName = casing + (clear == false ? "_glass_encased_shaft" : "_clear_glass_encased_shaft");
        CTSpriteShiftEntry ctEntry = CCSpriteShifts.GLASS_CASING_SHIFTS.get(casing).get(clear);
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)reg.block(newName, factory).properties(BlockBehaviour.Properties::m_60955_).properties(RegistrateGenHelper::glassProperties).transform((NonNullFunction)BlockStressDefaults.setNoImpact())).loot((p, lb) -> p.m_246125_((Block)lb, (ItemLike)AllBlocks.SHAFT)).addLayer(() -> RenderType::m_110463_).onRegister(CreateRegistrate.connectedTextures(() -> new GlassEncasedCTBehaviour(ctEntry)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, ctEntry, (state, face) -> true)))).initialProperties(() -> Blocks.f_50058_).transform(TagGen.pickaxeOnly())).transform(RegistrationGenPlatform.glassEncasedshaft(modId, casing, clear))).transform(RegistrationGenPlatform.addVariant(Create.asResource((String)"shaft"), AllBlocks.SHAFT))).transform(ItemVisibilityHandler.makeInvisible())).register();
    }

    public static <T extends AbstractRegistrate<T>> BlockEntry<GlassEncasedCogwheel> glassEncasedCogwheel(T reg, String modId, String casingType, Boolean large, Boolean clear, NonNullFunction<BlockBehaviour.Properties, GlassEncasedCogwheel> factory) {
        CTSpriteShiftEntry mainShift = CCSpriteShifts.GLASS_CASING_SHIFTS.get(casingType).get(clear);
        Object name = clear != false ? casingType + "_clear" : casingType;
        return large == false ? ((BlockBuilder)((BlockBuilder)reg.block((String)name + "_glass_encased_cogwheel", factory).loot((p, lb) -> p.m_246125_((Block)lb, (ItemLike)AllBlocks.COGWHEEL)).transform(RegistrateGenHelper.glassEncasedSmallCogwheel(modId, casingType, clear, () -> mainShift))).onRegister(CreateRegistrate.connectedTextures(() -> RegistrateGenHelper.getCoupledCTBehaviour(mainShift, casingType)))).register() : ((BlockBuilder)reg.block((String)name + "_glass_encased_large_cogwheel", factory).loot((p, lb) -> p.m_246125_((Block)lb, (ItemLike)AllBlocks.LARGE_COGWHEEL)).transform(RegistrateGenHelper.glassEncasedLargeCogwheel(modId, casingType, clear, () -> mainShift))).register();
    }

    @NotNull
    private static GlassEncasedCogCTBehaviour getCoupledCTBehaviour(CTSpriteShiftEntry mainShift, String casingType) {
        CTSpriteShiftEntry side = CCSpriteShifts.vertical("encased_cogwheels/" + casingType + "_encased_cogwheel_side");
        CTSpriteShiftEntry otherSide = CCSpriteShifts.horizontal("encased_cogwheels/" + casingType + "_encased_cogwheel_side");
        return new GlassEncasedCogCTBehaviour(mainShift, (Couple<CTSpriteShiftEntry>)Couple.create((Object)side, (Object)otherSide));
    }

    private static <B extends GlassEncasedCogwheel, P> NonNullUnaryOperator<BlockBuilder<B, P>> glassEncasedSmallCogwheel(String modid, String casing, Boolean clear, Supplier<CTSpriteShiftEntry> casingShift) {
        return b -> RegistrateGenHelper.glassEncasedCogwheelBase(b, modid, casing, clear, casingShift, false);
    }

    private static <B extends GlassEncasedCogwheel, P> NonNullUnaryOperator<BlockBuilder<B, P>> glassEncasedLargeCogwheel(String modid, String casing, Boolean clear, Supplier<CTSpriteShiftEntry> casingShift) {
        return b -> (BlockBuilder)RegistrateGenHelper.glassEncasedCogwheelBase(b, modid, casing, clear, casingShift, true).onRegister(CreateRegistrate.connectedTextures(() -> RegistrateGenHelper.lambda$glassEncasedLargeCogwheel$23((Supplier)casingShift)));
    }

    private static <B extends GlassEncasedCogwheel, P> BlockBuilder<B, P> glassEncasedCogwheelBase(BlockBuilder<B, P> b, String modId, String casing, Boolean clear, Supplier<CTSpriteShiftEntry> casingShift, boolean large) {
        String name = clear != false ? casing + "_clear_glass" : casing + "_glass";
        String blockFolder = "encased_cogwheel";
        BlockEntry encasable = large ? AllBlocks.LARGE_COGWHEEL : AllBlocks.COGWHEEL;
        ResourceLocation loc = Create.asResource((String)(large ? "large_cogwheel" : "cogwheel"));
        return (BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)b.properties(BlockBehaviour.Properties::m_60955_).properties(RegistrateGenHelper::glassProperties).transform((NonNullFunction)BlockStressDefaults.setNoImpact())).addLayer(() -> RenderType::m_110463_).initialProperties(() -> Blocks.f_50058_).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, (CTSpriteShiftEntry)casingShift.get(), (state, f) -> state.m_60734_() instanceof GlassEncasedCogwheel && f.m_122434_() == state.m_61143_((Property)GlassEncasedCogwheel.AXIS) && (Boolean)state.m_61143_((Property)(f.m_122421_() == Direction.AxisDirection.POSITIVE ? GlassEncasedCogwheel.TOP_SHAFT : GlassEncasedCogwheel.BOTTOM_SHAFT)) == false)))).transform(RegistrationGenPlatform.glassEncasedCog(modId, casing, large, name, blockFolder))).transform(RegistrationGenPlatform.addVariant(loc, encasable))).transform(ItemVisibilityHandler.makeInvisible());
    }

    public static ResourceLocation getBacking(String modid, String casing) {
        ResourceLocation texture = casing.equals("andesite") ? new ResourceLocation("block/stripped_spruce_log_top") : (casing.equals("brass") ? new ResourceLocation("block/stripped_dark_oak_log_top") : new ResourceLocation(modid, "block/" + casing + "_backing"));
        return texture;
    }

    public static ResourceLocation getSiding(String modid, String casing, boolean large) {
        ResourceLocation texture = new ResourceLocation(modid, "block/encased_cogwheels/" + (large ? "large_" : "") + casing + "_encased_cogwheel_side");
        return texture;
    }

    public static ResourceLocation getOpening(String modid, String casing) {
        ResourceLocation texture = casing.equals("andesite") ? Create.asResource((String)"block/gearbox") : (casing.equals("brass") ? Create.asResource((String)"block/brass_gearbox") : new ResourceLocation(modid, "block/" + casing + "_gearbox"));
        return texture;
    }

    private static BlockBehaviour.Properties glassProperties(BlockBehaviour.Properties p) {
        return p.m_60922_(($, $$, $$$, $$$$) -> false).m_60924_(($, $$, $$$) -> false).m_60960_(($, $$, $$$) -> false).m_60971_(($, $$, $$$) -> false);
    }

    private static /* synthetic */ ConnectedTextureBehaviour lambda$glassEncasedLargeCogwheel$23(Supplier casingShift) {
        return new GlassEncasedCogCTBehaviour((CTSpriteShiftEntry)casingShift.get());
    }

    public record IDArrayHolder<T>(Map<String, T> backing) {
        public T get(String key) {
            return this.backing.get(key);
        }

        public IDArrayHolder<T> add(String key, T val) {
            this.backing.put(key, val);
            return this;
        }
    }
}

