/*
 * Decompiled with CFR 0.152.
 */
package com.cyvack.crystal_clear.common.registry;

import com.cyvack.crystal_clear.common.CrystalClear;
import com.cyvack.crystal_clear.common.util.CasingTypes;
import com.simibubi.create.foundation.block.connected.AllCTTypes;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTSpriteShifter;
import com.simibubi.create.foundation.block.connected.CTType;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class CCSpriteShifts {
    public static final Map<String, MultiShiftHolder> GLASS_CASING_SHIFTS = new IdentityHashMap<String, MultiShiftHolder>();

    public static void populateMaps() {
        for (String name : CasingTypes.NORMAL_CASINGS.names) {
            GLASS_CASING_SHIFTS.put(name, MultiShiftHolder.createHolder((CTType)AllCTTypes.OMNIDIRECTIONAL, name));
        }
    }

    public static CTSpriteShiftEntry omni(String name) {
        return CCSpriteShifts.getCT((CTType)AllCTTypes.OMNIDIRECTIONAL, name);
    }

    public static CTSpriteShiftEntry horizontal(String name) {
        return CCSpriteShifts.getCT((CTType)AllCTTypes.HORIZONTAL, name);
    }

    public static CTSpriteShiftEntry vertical(String name) {
        return CCSpriteShifts.getCT((CTType)AllCTTypes.VERTICAL, name);
    }

    private static CTSpriteShiftEntry getCT(CTType type, String blockTextureName, String connectedTextureName) {
        return CTSpriteShifter.getCT((CTType)type, (ResourceLocation)CrystalClear.path("block/" + blockTextureName), (ResourceLocation)CrystalClear.path("block/" + connectedTextureName + "_connected"));
    }

    private static CTSpriteShiftEntry getCT(CTType type, String blockTextureName) {
        return CCSpriteShifts.getCT(type, blockTextureName, blockTextureName);
    }

    public record MultiShiftHolder(CTSpriteShiftEntry regular, CTSpriteShiftEntry clear) {
        public CTSpriteShiftEntry get(boolean clear) {
            return clear ? this.clear() : this.regular();
        }

        private static MultiShiftHolder createHolder(CTType type, String casingName) {
            CTSpriteShiftEntry regularShift = null;
            CTSpriteShiftEntry clearShift = null;
            for (boolean clear : Iterate.falseAndTrue) {
                String loc = casingName.concat(clear ? "_clear" : "").concat("_glass_casing");
                if (clear) {
                    clearShift = CCSpriteShifts.getCT(type, loc);
                    continue;
                }
                regularShift = CCSpriteShifts.getCT(type, loc);
            }
            return new MultiShiftHolder(regularShift, clearShift);
        }
    }
}

