/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.parent;

import java.util.ArrayList;
import java.util.List;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.controls.parent.GuiRow;
import team.creative.creativecore.common.gui.controls.parent.GuiScrollXY;
import team.creative.creativecore.common.gui.controls.parent.GuiTable;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.type.itr.FunctionIterator;

public class GuiTableScrollable
extends GuiParent {
    protected GuiRow topRow = new GuiRow(){

        @Override
        public double getOffsetX() {
            return GuiTableScrollable.this.scrollableTable.getOffsetX();
        }
    };
    protected GuiParent bottom = new GuiParent();
    protected GuiParent firstCol = new GuiParent((GuiFlow)GuiFlow.STACK_Y){

        @Override
        public double getOffsetY() {
            return GuiTableScrollable.this.scrollableTable.getOffsetY();
        }
    };
    protected GuiScrollXY scrollableTable = new GuiScrollXY("", GuiFlow.STACK_Y){

        @Override
        public void flowX(int width, int preferred) {
            this.updateWidth();
        }

        @Override
        public void flowY(int width, int height, int preferred) {
            this.updateHeight();
        }

        @Override
        public ControlFormatting getControlFormatting() {
            return ControlFormatting.TRANSPARENT;
        }
    };

    public GuiTableScrollable() {
        this("");
    }

    public GuiTableScrollable(String name) {
        super(name);
        this.scrollableTable.scrollbarThickness = 2;
        this.scrollableTable.scrollbarFace = ControlFormatting.ControlStyleFace.CLICKABLE_INACTIVE;
        this.scrollableTable.alternativeScrolling = true;
        this.flow = GuiFlow.STACK_Y;
        super.addControl(this.topRow);
        super.addControl(this.bottom);
        this.bottom.add((GuiControl)this.firstCol);
        this.bottom.add((GuiControl)this.scrollableTable);
        this.spacing = 4;
    }

    @Override
    @Deprecated
    public GuiChildControl addControl(GuiControl control) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GuiTableScrollable setExpandable() {
        return (GuiTableScrollable)super.setExpandable();
    }

    public GuiRow getTopRow() {
        return this.topRow;
    }

    public GuiTableScrollable addRow(GuiRow row) {
        if (row.colCount() == 0) {
            return this;
        }
        this.firstCol.add((GuiControl)row.removeCol(0));
        this.scrollableTable.add((GuiControl)row);
        return this;
    }

    @Override
    public boolean isExpandableX() {
        return this.expandableX;
    }

    @Override
    public boolean isExpandableY() {
        return this.expandableY;
    }

    protected List<GuiTable.GuiTableGroup> createCols() {
        ArrayList<GuiTable.GuiTableGroup> cols = new ArrayList<GuiTable.GuiTableGroup>();
        int i = 0;
        for (GuiChildControl cell : this.topRow) {
            if (cols.size() <= i) {
                cols.add(new GuiTable.GuiTableGroup());
            }
            ((GuiTable.GuiTableGroup)cols.get((int)i)).controls.add(cell);
            ++i;
        }
        GuiTable.GuiTableGroup first = (GuiTable.GuiTableGroup)cols.get(0);
        for (GuiChildControl child : this.firstCol) {
            first.controls.add(child);
        }
        for (GuiChildControl child : this.scrollableTable) {
            GuiRow row = (GuiRow)child.control;
            i = 1;
            for (GuiChildControl cell : row) {
                if (cols.size() <= i) {
                    cols.add(new GuiTable.GuiTableGroup());
                }
                ((GuiTable.GuiTableGroup)cols.get((int)i)).controls.add(cell);
                ++i;
            }
        }
        return cols;
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return GuiFlow.STACK_X.preferredWidth(this.createCols(), this.spacing, availableWidth);
    }

    @Override
    public void flowX(int width, int preferred) {
        List<GuiTable.GuiTableGroup> cols = this.createCols();
        GuiFlow.STACK_X.flowX(cols, this.spacing, Align.LEFT, width, preferred, this.endlessX());
        GuiChildControl startCol = cols.get(0);
        int startX = startCol.getX();
        GuiChildControl lastCol = cols.get(cols.size() - 1);
        int combinedWidth = Math.min(width, lastCol.getWidth() + lastCol.getX() - startX);
        GuiChildControl bottomChild = this.find(this.bottom);
        bottomChild.setX(0);
        bottomChild.setWidth(combinedWidth + startX, width);
        GuiChildControl firstColChild = this.bottom.find(this.firstCol);
        firstColChild.setX(startX);
        firstColChild.setWidth(startCol.getWidth(), width);
        GuiChildControl topRowChild = this.find(this.topRow);
        topRowChild.setX(startX);
        topRowChild.setWidth(combinedWidth, width);
        GuiChildControl scrollableChild = this.bottom.find(this.scrollableTable);
        scrollableChild.setX(startX + startCol.getWidth());
        scrollableChild.setWidth(combinedWidth -= startCol.getWidth(), width);
        combinedWidth = lastCol.getWidth() + lastCol.getX() - startX - startCol.getWidth();
        startX += startCol.getWidth();
        for (GuiChildControl row : this.scrollableTable) {
            row.setX(0);
            row.setWidth(combinedWidth, width);
            for (GuiChildControl col : (GuiRow)row.control) {
                col.setX(col.getX() - startX);
            }
        }
        scrollableChild.flowX();
    }

    protected List<GuiChildControl> createRows() {
        ArrayList<GuiChildControl> rows = new ArrayList<GuiChildControl>();
        rows.add(this.find(this.topRow));
        int i = 1;
        for (GuiChildControl row : this.firstCol) {
            if (rows.size() <= i) {
                rows.add(new GuiTable.GuiTableGroup());
            }
            ((GuiTable.GuiTableGroup)rows.get((int)i)).controls.add(row);
            ++i;
        }
        i = 1;
        for (GuiChildControl row : this.scrollableTable) {
            if (rows.size() <= i) {
                rows.add(new GuiTable.GuiTableGroup());
            }
            ((GuiTable.GuiTableGroup)rows.get((int)i)).controls.add(row);
            ++i;
        }
        return rows;
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return GuiFlow.STACK_Y.preferredHeight(this.createRows(), this.spacing, width, availableHeight);
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        List<GuiChildControl> rows = this.createRows();
        GuiFlow.STACK_Y.flowY(rows, this.spacing, VAlign.TOP, width, height, preferred, this.endlessY());
        int startY = rows.size() > 1 ? rows.get(1).getY() : rows.get(0).getHeight() + rows.get(0).getY();
        GuiChildControl lastRow = rows.get(rows.size() - 1);
        for (int j = 1; j < rows.size(); ++j) {
            for (GuiChildControl child : ((GuiTable.GuiTableGroup)rows.get((int)j)).controls) {
                child.setY(child.getY() - startY);
            }
        }
        int combinedHeight = Math.min(height - startY, lastRow.getHeight() + lastRow.getY() - startY);
        GuiChildControl bottomChild = this.find(this.bottom);
        bottomChild.setY(startY);
        bottomChild.setHeight(combinedHeight, height);
        GuiChildControl firstColChild = this.bottom.find(this.firstCol);
        firstColChild.setY(0);
        firstColChild.setHeight(combinedHeight, height);
        GuiChildControl scrollableChild = this.bottom.find(this.scrollableTable);
        scrollableChild.setY(0);
        scrollableChild.setHeight(combinedHeight, height);
        scrollableChild.flowY();
    }

    @Override
    protected boolean endlessX() {
        return true;
    }

    @Override
    protected boolean endlessY() {
        return true;
    }

    public void removeContentCol(int index) {
        this.topRow.removeCol(index + 1);
        for (GuiChildControl child : this.scrollableTable) {
            ((GuiRow)child.control).removeCol(index);
        }
    }

    public Iterable<GuiRow> contentRows() {
        return new FunctionIterator<GuiRow>(this.scrollableTable, x -> (GuiRow)x.control);
    }
}

