/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.interpolation;

import java.util.List;
import java.util.Map;
import team.creative.creativecore.common.util.math.vec.VecNd;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.list.TupleList;

public abstract class Interpolation<T extends VecNd> {
    protected TupleList<Double, T> points = new TupleList();
    private final Class classOfT;

    public Interpolation(double[] times, T[] points) {
        if (points.length < 2) {
            throw new IllegalArgumentException("At least two points are needed!");
        }
        if (times.length != points.length) {
            throw new IllegalArgumentException("Invalid times array!");
        }
        this.classOfT = points[0].getClass();
        for (int i = 0; i < points.length; ++i) {
            this.points.add(times[i], points[i]);
        }
    }

    public Interpolation(TupleList<Double, T> points) {
        if (points.size() < 2) {
            throw new IllegalArgumentException("At least two points are needed!");
        }
        this.classOfT = ((VecNd)points.getFirst().value).getClass();
        this.points = new TupleList(points);
    }

    public Interpolation(double[] times, List<T> points) {
        if (points.size() < 2) {
            throw new IllegalArgumentException("At least two points are needed!");
        }
        if (times.length != points.size()) {
            throw new IllegalArgumentException("Invalid times array!");
        }
        this.classOfT = ((VecNd)points.get(0)).getClass();
        for (int i = 0; i < points.size(); ++i) {
            this.points.add(times[i], (VecNd)points.get(i));
        }
    }

    public Interpolation(List<T> points) {
        if (points.size() < 2) {
            throw new IllegalArgumentException("At least two points are needed!");
        }
        double time = 0.0;
        double stepLength = 1.0 / (double)(points.size() - 1);
        this.classOfT = ((VecNd)points.get(0)).getClass();
        for (VecNd t : points) {
            this.points.add(time, t);
            time += stepLength;
        }
    }

    public Interpolation(T ... points) {
        if (points.length < 2) {
            throw new IllegalArgumentException("At least two points are needed!");
        }
        this.classOfT = points[0].getClass();
        double time = 0.0;
        double stepLength = 1.0 / (double)(points.length - 1);
        for (int i = 0; i < points.length; ++i) {
            this.points.add(time, points[i]);
            time += stepLength;
        }
    }

    protected double getValue(int index, int dim) {
        return ((VecNd)((Tuple)this.points.get((int)index)).value).get(dim);
    }

    public T valueAt(double t) {
        Map.Entry firstPoint = null;
        int indexFirst = -1;
        Map.Entry secondPoint = null;
        int indexSecond = -1;
        int i = 0;
        for (Tuple tuple : this.points) {
            if ((Double)tuple.getKey() >= t) {
                if (firstPoint == null) {
                    firstPoint = tuple;
                    indexFirst = i;
                    break;
                }
                secondPoint = tuple;
                indexSecond = i;
                break;
            }
            firstPoint = tuple;
            indexFirst = i++;
        }
        if (secondPoint == null) {
            return ((VecNd)firstPoint.getValue()).copy();
        }
        Object vec = ((VecNd)firstPoint.getValue()).copy();
        double d = (Double)secondPoint.getKey() - (Double)firstPoint.getKey();
        double mu = (t - (Double)firstPoint.getKey()) / d;
        for (int dim = 0; dim < ((VecNd)vec).dimensions(); ++dim) {
            ((VecNd)vec).set(dim, this.valueAt(mu, indexFirst, indexSecond, dim));
        }
        return vec;
    }

    protected T createVec() {
        return VecNd.createEmptyVec(this.classOfT);
    }

    public abstract double valueAt(double var1, int var3, int var4, int var5);

    public abstract double[] estimateDistance();
}

