/*
 * Decompiled with CFR 0.152.
 */
package me.mangorage.curiotiab.client.screens.overlays;

import com.magorage.tiab.api.ITimeInABottleAPI;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import me.mangorage.curiotiab.client.config.CurioTiabClientConfig;
import me.mangorage.curiotiab.common.core.Util;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class CurioTiabHudOverlay
implements IGuiOverlay {
    private static final CurioTiabHudOverlay INSTANCE = new CurioTiabHudOverlay();
    private final AtomicBoolean HIDDEN = new AtomicBoolean(true);
    private ITimeInABottleAPI API = null;
    private int x;
    private int y = 5;
    private boolean check = true;

    public static CurioTiabHudOverlay getInstance() {
        return INSTANCE;
    }

    public static void setHidden(boolean value) {
        CurioTiabHudOverlay.getInstance().HIDDEN.set(value);
    }

    public static boolean isHidden() {
        return CurioTiabHudOverlay.getInstance().HIDDEN.get();
    }

    private CurioTiabHudOverlay() {
    }

    public void setAPI(ITimeInABottleAPI api) {
        if (this.API != null) {
            return;
        }
        this.API = api;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        CurioTiabClientConfig.setPOSX(x);
        CurioTiabClientConfig.setPOSY(y);
        CurioTiabClientConfig.save(CurioTiabClientConfig.Type.POSX, CurioTiabClientConfig.Type.POSY);
        CurioTiabClientConfig.invalidateCache(CurioTiabClientConfig.Type.POSX);
        CurioTiabClientConfig.invalidateCache(CurioTiabClientConfig.Type.POSY);
    }

    public void toggleOverlay() {
        this.HIDDEN.set(!this.HIDDEN.get());
    }

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        ItemStack TIAB;
        if (this.HIDDEN.get()) {
            return;
        }
        if (this.check) {
            this.x = CurioTiabClientConfig.getPosX();
            this.y = CurioTiabClientConfig.getPosY();
            this.check = !this.check;
        }
        AtomicInteger yOffset = new AtomicInteger(0);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Font font = Minecraft.m_91087_().f_91062_;
        if (player != null && (TIAB = Util.getTiabCurioItemStack((Player)player)) != ItemStack.f_41583_) {
            ArrayList<Object> Lines = new ArrayList<Object>();
            if (CurioTiabClientConfig.useHeader()) {
                Lines.add(0, Component.m_237113_((String)"Time in a Bottle Curio").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.GOLD));
            }
            switch (CurioTiabClientConfig.getOverlayMode()) {
                case TOTAL: {
                    Lines.add(this.API.getTotalTimeTranslated(TIAB));
                    break;
                }
                case CURRENT: {
                    Lines.add(this.API.getStoredTimeTranslated(TIAB));
                    break;
                }
                case BOTH: {
                    Lines.add(this.API.getStoredTimeTranslated(TIAB));
                    Lines.add(this.API.getTotalTimeTranslated(TIAB));
                }
            }
            Lines.forEach(component -> guiGraphics.m_280430_(font, component, this.x, this.y + yOffset.getAndAdd(10), 128));
        }
    }

    public static enum Mode {
        TOTAL,
        CURRENT,
        BOTH;

    }
}

