/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.registry.market;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheads;
import net.blay09.mods.farmingforblockheads.api.FarmingForBlockheadsAPI;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketRegistryDefaultHandler;
import net.blay09.mods.farmingforblockheads.api.MarketRegistryReloadEvent;
import net.blay09.mods.farmingforblockheads.registry.MarketCategory;
import net.blay09.mods.farmingforblockheads.registry.MarketRegistry;
import net.blay09.mods.farmingforblockheads.registry.json.ItemStackSerializer;
import net.blay09.mods.farmingforblockheads.registry.json.MarketRegistryDataSerializer;
import net.blay09.mods.farmingforblockheads.registry.market.MarketRegistryData;
import net.blay09.mods.farmingforblockheads.registry.market.MarketRegistrySilentData;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class MarketRegistryLoader
implements ResourceManagerReloadListener {
    private static final FileToIdConverter COMPAT_JSONS = FileToIdConverter.m_246568_((String)"farmingforblockheads_compat");
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(ItemStack.class, (Object)new ItemStackSerializer()).registerTypeAdapter(MarketRegistryData.class, (Object)new MarketRegistryDataSerializer()).create();
    private static final List<Exception> registryErrorsToAnnounce = new ArrayList<Exception>();

    public void m_6213_(ResourceManager resourceManager) {
        try {
            Reader reader;
            MarketRegistry.INSTANCE.reset();
            registryErrorsToAnnounce.clear();
            Balm.getEvents().fireEvent((Object)new MarketRegistryReloadEvent.Pre());
            for (Map.Entry entry : COMPAT_JSONS.m_247457_(resourceManager).entrySet()) {
                try {
                    reader = ((Resource)entry.getValue()).m_215508_();
                    try {
                        this.load((MarketRegistryData)gson.fromJson(reader, MarketRegistryData.class));
                    }
                    finally {
                        if (reader == null) continue;
                        ((BufferedReader)reader).close();
                    }
                }
                catch (Exception e) {
                    FarmingForBlockheads.logger.error("Parsing error loading Farming for Blockheads data file at {}", entry.getKey(), (Object)e);
                    if (!this.shouldAnnounceRegistryErrors((Resource)entry.getValue())) continue;
                    registryErrorsToAnnounce.add(e);
                }
            }
            File configDir = new File(Balm.getConfig().getConfigDir(), "farmingforblockheads");
            if (configDir.exists() || configDir.mkdirs()) {
                File configFile = new File(configDir, "MarketRegistry.json");
                if (configFile.exists()) {
                    try {
                        reader = new FileReader(configFile);
                        try {
                            this.load((MarketRegistryData)gson.fromJson(reader, MarketRegistryData.class));
                        }
                        finally {
                            ((InputStreamReader)reader).close();
                        }
                    }
                    catch (Exception e) {
                        FarmingForBlockheads.logger.error("Parsing error loading Farming for Blockheads data from MarketRegistry.json", (Throwable)e);
                        registryErrorsToAnnounce.add(e);
                    }
                } else {
                    try (FileWriter writer = new FileWriter(configFile);){
                        gson.toJson((Object)new MarketRegistryData(), (Appendable)writer);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            MarketRegistry.INSTANCE.registerDefaults();
            Balm.getEvents().fireEvent((Object)new MarketRegistryReloadEvent.Post());
        }
        catch (Exception e) {
            FarmingForBlockheads.logger.error("Exception loading Farming for Blockheads data", (Throwable)e);
            registryErrorsToAnnounce.add(e);
        }
    }

    private boolean shouldAnnounceRegistryErrors(Resource resource) {
        boolean bl;
        block8: {
            BufferedReader reader = resource.m_215508_();
            try {
                boolean bl2 = bl = !((MarketRegistrySilentData)gson.fromJson((Reader)reader, MarketRegistrySilentData.class)).isSilent();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ignored) {
                    return true;
                }
            }
            reader.close();
        }
        return bl;
    }

    private void load(final @Nullable MarketRegistryData data) {
        if (data == null) {
            return;
        }
        if (data.getModId() != null && !data.getModId().equals("minecraft") && !Balm.isModLoaded((String)data.getModId())) {
            return;
        }
        if (data.getGroup() != null) {
            FarmingForBlockheadsAPI.registerMarketDefaultHandler(data.getGroup().getName(), new IMarketRegistryDefaultHandler(){

                @Override
                public void register(@Nullable ItemStack overridePayment, @Nullable Integer overrideCount) {
                    ItemStack effectiveDefaultPayment = data.getGroup().getDefaultPayment();
                    if (effectiveDefaultPayment == null) {
                        effectiveDefaultPayment = this.getDefaultPayment();
                    }
                    if (overridePayment != null) {
                        effectiveDefaultPayment = overridePayment;
                    }
                    MarketRegistryLoader.this.loadMarketData(data, effectiveDefaultPayment, overrideCount);
                }

                @Override
                public boolean isEnabledByDefault() {
                    return data.getGroup().isEnabledByDefault();
                }

                @Override
                public ItemStack getDefaultPayment() {
                    return new ItemStack((ItemLike)Items.f_42616_);
                }
            });
        } else {
            this.loadMarketData(data, new ItemStack((ItemLike)Items.f_42616_), null);
        }
    }

    private void loadMarketData(MarketRegistryData data, ItemStack defaultPayment, @Nullable Integer overrideCount) {
        if (data.getCustomCategories() != null) {
            data.getCustomCategories().forEach((key, categoryData) -> {
                ResourceLocation resourceLocation = new ResourceLocation(key);
                MarketRegistry.INSTANCE.registerCategory(new MarketCategory(resourceLocation, categoryData.getName(), categoryData.getIcon(), categoryData.getSortIndex()));
            });
        }
        if (data.getEntryOverrides() != null) {
            data.getEntryOverrides().forEach(MarketRegistry.INSTANCE::registerEntryOverride);
        }
        if (data.getGroupOverrides() != null) {
            data.getGroupOverrides().forEach(MarketRegistry.INSTANCE::registerGroupOverride);
        }
        if (data.getCustomEntries() != null) {
            data.getCustomEntries().forEach(it -> {
                ResourceLocation categoryKey = it.getCategory();
                if (categoryKey == null) {
                    categoryKey = data.getGroup() != null ? data.getGroup().getDefaultCategory() : new ResourceLocation("farmingforblockheads:other");
                }
                IMarketCategory category = MarketRegistry.getCategory(categoryKey);
                ItemStack effectivePayment = it.getPayment();
                if (effectivePayment == null) {
                    effectivePayment = defaultPayment;
                }
                ItemStack effectiveOutput = it.getOutput();
                if (overrideCount != null) {
                    effectiveOutput = ContainerUtils.copyStackWithSize((ItemStack)effectiveOutput, (int)overrideCount);
                }
                MarketRegistry.INSTANCE.registerEntry(effectiveOutput, effectivePayment, category);
            });
        }
    }

    public static void onLogin(PlayerLoginEvent event) {
        if (!registryErrorsToAnnounce.isEmpty()) {
            event.getPlayer().m_5661_(MarketRegistryLoader.getErrorTextComponent("There were registry errors in the FarmingForBlockheads market data. See the log for full details."), false);
            for (Exception registryError : registryErrorsToAnnounce) {
                event.getPlayer().m_5661_(MarketRegistryLoader.getErrorTextComponent("- " + registryError.getMessage()), false);
            }
        }
    }

    private static Component getErrorTextComponent(String message) {
        MutableComponent result = Component.m_237113_((String)message);
        result.m_130940_(ChatFormatting.RED);
        return result;
    }
}

