/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.capture.component;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.capture.Capture;
import io.github.mortuusars.exposure.camera.capture.component.ICaptureComponent;

public class FlashComponent
implements ICaptureComponent {
    @Override
    public int getTicksDelay(Capture capture) {
        return 1 + (Integer)Config.Client.FLASH_CAPTURE_DELAY_TICKS.get();
    }

    @Override
    public void initialize(Capture capture) {
        int ticksDelay = capture.getTicksDelay();
        int framesDelay = capture.getFramesDelay();
        if (ticksDelay > 6) {
            Exposure.LOGGER.warn("Capture ticksDelay of '{}' can be too long for use with a flash. The flash might disappear in that time.", (Object)ticksDelay);
        }
        if (framesDelay > 20) {
            Exposure.LOGGER.warn("Capture framesDelay of '{}' can be too long for use with a flash. The flash might disappear in that time.", (Object)ticksDelay);
        }
    }
}

