/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render.image;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.render.image.IImage;
import java.io.IOException;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextureImage
extends SimpleTexture
implements IImage {
    private final String name;
    @Nullable
    private NativeImage image;

    public TextureImage(ResourceLocation location) {
        super(location);
        this.name = location.toString();
    }

    @Override
    public String getImageId() {
        return this.name;
    }

    @Override
    public int getWidth() {
        @Nullable NativeImage image = this.getImage();
        return image != null ? image.m_84982_() : 1;
    }

    @Override
    public int getHeight() {
        @Nullable NativeImage image = this.getImage();
        return image != null ? image.m_85084_() : 1;
    }

    @Override
    public int getPixelABGR(int x, int y) {
        @Nullable NativeImage image = this.getImage();
        return image != null ? image.m_84985_(x, y) : 0;
    }

    @Nullable
    public static TextureImage getTexture(ResourceLocation location) {
        TextureManager textureManager = Minecraft.m_91087_().m_91097_();
        @Nullable AbstractTexture existingTexture = (AbstractTexture)textureManager.f_118468_.get(location);
        if (existingTexture != null) {
            TextureImage exposureTexture;
            return existingTexture instanceof TextureImage ? (exposureTexture = (TextureImage)existingTexture) : null;
        }
        try {
            TextureImage texture = new TextureImage(location);
            textureManager.m_118495_(location, (AbstractTexture)texture);
            return texture;
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Cannot load texture [{}]. {}", (Object)location, (Object)e);
            return null;
        }
    }

    @Nullable
    public NativeImage getImage() {
        if (this.image != null) {
            return this.image;
        }
        try {
            NativeImage image;
            this.image = image = super.m_6335_(Minecraft.m_91087_().m_91098_()).m_118158_();
            return image;
        }
        catch (IOException e) {
            Exposure.LOGGER.error("Cannot load texture: {}", (Object)e.toString());
            return null;
        }
    }

    public void m_6479_(@NotNull TextureManager pTextureManager, @NotNull ResourceManager pResourceManager, @NotNull ResourceLocation pPath, @NotNull Executor pExecutor) {
        super.m_6479_(pTextureManager, pResourceManager, pPath, pExecutor);
        if (this.image != null) {
            this.image.close();
            this.image = null;
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.image != null) {
            this.image.close();
            this.image = null;
        }
    }
}

