/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render.modifiers;

import io.github.mortuusars.exposure.render.modifiers.IPixelModifier;
import net.minecraft.util.FastColor;

public class MultiplyPixelModifier
implements IPixelModifier {
    public final int multiplyColor;

    public MultiplyPixelModifier(int multiplyColor) {
        this.multiplyColor = multiplyColor;
    }

    @Override
    public int modifyPixel(int ABGR) {
        if (this.multiplyColor == 0) {
            return ABGR;
        }
        int alpha = FastColor.ABGR32.m_266503_((int)ABGR);
        int blue = FastColor.ABGR32.m_266247_((int)ABGR);
        int green = FastColor.ABGR32.m_266446_((int)ABGR);
        int red = FastColor.ABGR32.m_266313_((int)ABGR);
        int tintAlpha = FastColor.ARGB32.m_13655_((int)ABGR);
        int tintBlue = FastColor.ARGB32.m_13669_((int)ABGR);
        int tintGreen = FastColor.ARGB32.m_13667_((int)ABGR);
        int tintRed = FastColor.ARGB32.m_13665_((int)ABGR);
        alpha = Math.min(255, alpha * tintAlpha / 255);
        blue = Math.min(255, blue * tintBlue / 255);
        green = Math.min(255, green * tintGreen / 255);
        red = Math.min(255, red * tintRed / 255);
        return FastColor.ABGR32.m_266248_((int)alpha, (int)blue, (int)green, (int)red);
    }

    @Override
    public String getIdSuffix() {
        return this.multiplyColor != 0 ? "_tint" + Integer.toHexString(this.multiplyColor) : "";
    }
}

