/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.sound;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.sound.instance.ShutterTimerTickingSoundInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class OnePerPlayerSoundsClient {
    private static final Map<Player, List<SoundInstance>> instances = new HashMap<Player, List<SoundInstance>>();

    public static void play(Player sourcePlayer, SoundEvent soundEvent, SoundSource source, float volume, float pitch) {
        Level level = sourcePlayer.m_9236_();
        OnePerPlayerSoundsClient.stop(sourcePlayer, soundEvent);
        SoundInstance soundInstance = OnePerPlayerSoundsClient.createSoundInstance(sourcePlayer, soundEvent, source, volume, pitch, level);
        List playingSounds = Optional.ofNullable(instances.get(sourcePlayer)).orElse(new ArrayList());
        playingSounds.add(soundInstance);
        instances.put(sourcePlayer, playingSounds);
        Minecraft.m_91087_().m_91106_().m_120367_(soundInstance);
    }

    public static void stop(Player sourcePlayer, SoundEvent soundEvent) {
        if (instances.containsKey(sourcePlayer)) {
            ResourceLocation soundLocation = soundEvent.m_11660_();
            List<SoundInstance> playingSounds = instances.remove(sourcePlayer);
            for (int i = playingSounds.size() - 1; i >= 0; --i) {
                SoundInstance soundInstance = playingSounds.get(i);
                if (!soundInstance.m_7904_().equals((Object)soundLocation)) continue;
                Minecraft.m_91087_().m_91106_().m_120399_(soundInstance);
                playingSounds.remove(i);
            }
            instances.put(sourcePlayer, playingSounds);
        }
    }

    @NotNull
    private static SoundInstance createSoundInstance(Player sourcePlayer, SoundEvent soundEvent, SoundSource source, float volume, float pitch, Level level) {
        if (soundEvent == Exposure.SoundEvents.SHUTTER_TICKING.get()) {
            return new ShutterTimerTickingSoundInstance(sourcePlayer, soundEvent, source, volume, pitch, sourcePlayer.m_9236_().m_213780_());
        }
        return new EntityBoundSoundInstance(soundEvent, source, volume, pitch, (Entity)sourcePlayer, level.m_213780_().m_188505_());
    }
}

