/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.jumpoverfences.config;

import com.kreezcraft.jumpoverfences.Constants;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeFencesConfig {
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Constants.LOG.debug("Loaded Jump Over Fences' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Constants.LOG.warn("Jump Over Fences' config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> jumpTheseToo;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client settings").push("client");
            this.jumpTheseToo = builder.comment("modid:thingid list of stuff to jump, used for implicit jumping, for example the default list item 'cfm:oak_upgraded_fence").defineListAllowEmpty(List.of("jumpTheseToo"), () -> List.of("cfm:oak_upgraded_fence"), o -> o instanceof String);
            builder.pop();
        }
    }
}

