/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.block;

import com.ninni.spawn.SpawnProperties;
import com.ninni.spawn.block.entity.SunflowerBlockEntity;
import com.ninni.spawn.block.state.properties.SunflowerRotation;
import com.ninni.spawn.registry.SpawnBlockEntityTypes;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class SunflowerBlock
extends DoublePlantBlock
implements BonemealableBlock,
EntityBlock {
    public static final EnumProperty<SunflowerRotation> ROTATION = SpawnProperties.SUNFLOWER_ROTATION;
    public static final BooleanProperty SEEDS = SpawnProperties.SEEDS;

    public SunflowerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)SEEDS, (Comparable)Boolean.valueOf(false))).m_61124_(ROTATION, (Comparable)((Object)SunflowerRotation.DAY))).m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER));
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (blockState.m_61143_(ROTATION) != SunflowerRotation.NIGHT && ((Boolean)blockState.m_61143_((Property)SEEDS)).booleanValue() && blockState.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)SEEDS, (Comparable)Boolean.valueOf(false)), 3);
            int j = 1 + level.f_46441_.m_188503_(2);
            level.m_5594_(null, blockPos, (SoundEvent)SpawnSoundEvents.SUNFLOWER_SEED_PICKUP.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            SunflowerBlock.m_49840_((Level)level, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)SpawnItems.SUNFLOWER_SEEDS.get(), j));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public static SunflowerRotation getRotationType(Level world) {
        if (world.m_46462_() || world.m_46472_() != Level.f_46428_) {
            return SunflowerRotation.NIGHT;
        }
        if (world.m_8044_() < 2000L) {
            return SunflowerRotation.MORNING;
        }
        if (world.m_8044_() >= 7000L) {
            return SunflowerRotation.EVENING;
        }
        return SunflowerRotation.DAY;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ROTATION, f_52858_, SEEDS});
    }

    public boolean m_7370_(LevelReader levelReader, BlockPos blockPos, BlockState blockState, boolean bl) {
        return blockState.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER && (Boolean)blockState.m_61143_((Property)SEEDS) == false;
    }

    public boolean m_214167_(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return blockState.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER && (Boolean)blockState.m_61143_((Property)SEEDS) == false;
    }

    public void m_214148_(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        BlockState blockState2 = (BlockState)blockState.m_61124_((Property)SEEDS, (Comparable)Boolean.valueOf(true));
        serverLevel.m_7731_(blockPos, blockState2, 2);
        serverLevel.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223722_((BlockState)blockState2));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new SunflowerBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return !level.f_46443_ && blockState.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER ? SunflowerBlock.createTickerHelper(blockEntityType, (BlockEntityType)SpawnBlockEntityTypes.SUNFLOWER.get(), SunflowerBlockEntity::tick) : null;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> blockEntityType, BlockEntityType<E> blockEntityType2, BlockEntityTicker<? super E> blockEntityTicker) {
        return blockEntityType2 == blockEntityType ? blockEntityTicker : null;
    }
}

