/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.block.entity;

import com.google.common.collect.Lists;
import com.ninni.spawn.block.AnthillBlock;
import com.ninni.spawn.registry.SpawnBlockEntityTypes;
import com.ninni.spawn.registry.SpawnSoundEvents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class AnthillBlockEntity
extends BlockEntity {
    public static final String MIN_OCCUPATION_TICKS_KEY = "MinOccupationTicks";
    public static final String ENTITY_DATA_KEY = "EntityData";
    public static final String TICKS_IN_ANTHILL_KEY = "TicksInAnthill";
    public static final String ANTS_KEY = "Ants";
    private static final List<String> IGNORED_ANT_TAGS = Arrays.asList("Bees", "Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "CannotEnterAnthillTicks", "TicksSinceGathering", "AnthillPos", "Passengers", "Leash", "UUID");
    private final List<Ant> ants = Lists.newArrayList();
    @Nullable
    private BlockPos savedResourcePos;
    private boolean hasResource;

    public AnthillBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SpawnBlockEntityTypes.ANTHILL.get(), pos, state);
    }

    public boolean hasNoAnts() {
        return this.ants.isEmpty();
    }

    public boolean isFullOfAnts() {
        return this.ants.size() == 3;
    }

    public void angerAnts(@Nullable Player player, BlockState state, AntState antState) {
        List<Entity> list = this.tryReleaseAnt(state, antState);
        if (player != null) {
            for (Entity entity : list) {
                if (!(entity instanceof com.ninni.spawn.entity.Ant)) continue;
                com.ninni.spawn.entity.Ant ant = (com.ninni.spawn.entity.Ant)entity;
                if (!(player.m_20182_().m_82557_(entity.m_20182_()) <= 16.0)) continue;
                ant.m_6710_((LivingEntity)player);
                ant.setStayOutOfAnthillCountdown(400);
            }
        }
    }

    public void storeAnt(CompoundTag nbt, int i, boolean bl) {
        this.ants.add(new Ant(nbt, i, bl ? 2400 : 600));
    }

    private List<Entity> tryReleaseAnt(BlockState state, AntState antState) {
        ArrayList list = Lists.newArrayList();
        this.ants.removeIf(ant -> {
            assert (this.f_58857_ != null);
            return AnthillBlockEntity.releaseAnt(this.f_58857_, this.f_58858_, state, ant, list, antState, this.savedResourcePos);
        });
        if (!list.isEmpty()) {
            super.m_6596_();
        }
        return list;
    }

    public void tryEnterAnthill(Entity entity, boolean bl) {
        this.tryEnterAnthill(entity, bl, 0);
    }

    public void tryEnterAnthill(Entity entity, boolean bl, int ticksInAnthill) {
        if (this.ants.size() >= 3) {
            return;
        }
        entity.m_8127_();
        entity.m_20153_();
        CompoundTag nbtCompound = new CompoundTag();
        entity.m_20223_(nbtCompound);
        BlockPos blockPos = this.m_58899_();
        this.addAnt(nbtCompound, ticksInAnthill, bl, entity.m_9236_().m_213780_());
        if (this.f_58857_ != null) {
            if (entity instanceof com.ninni.spawn.entity.Ant) {
                com.ninni.spawn.entity.Ant ant = (com.ninni.spawn.entity.Ant)entity;
                if (ant.hasSavedResourcePos()) {
                    this.savedResourcePos = ant.getSavedResourcePos();
                }
                this.hasResource = ant.hasResource();
            }
            this.f_58857_.m_6263_(null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (SoundEvent)SpawnSoundEvents.ANTHILL_ENTER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            this.f_58857_.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)this.m_58900_()));
        }
        entity.m_146870_();
        super.m_6596_();
    }

    public void addAnt(CompoundTag nbtCompound, int ticksInAnthill, boolean bl, RandomSource random) {
        assert (this.f_58857_ != null);
        this.ants.add(new Ant(nbtCompound, ticksInAnthill, (bl ? 2400 : 600) + random.m_188503_(600)));
    }

    private static boolean releaseAnt(Level world, BlockPos pos, BlockState state, Ant ant, @Nullable List<Entity> entities, AntState antState, BlockPos resourcePos) {
        boolean bl;
        if (world.m_46462_() && antState != AntState.EMERGENCY) {
            return false;
        }
        CompoundTag nbtCompound = ant.entityData.m_6426_();
        AnthillBlockEntity.removeIrrelevantNbtKeys(nbtCompound);
        nbtCompound.m_128365_("AnthillPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        boolean bl2 = bl = !world.m_8055_(pos.m_7494_()).m_60812_((BlockGetter)world, pos.m_7494_()).m_83281_();
        if (bl && antState != AntState.EMERGENCY) {
            return false;
        }
        Entity newAnt = EntityType.m_20645_((CompoundTag)nbtCompound, (Level)world, entity -> entity);
        if (newAnt != null) {
            com.ninni.spawn.entity.Ant releasedAnt;
            if (newAnt instanceof com.ninni.spawn.entity.Ant) {
                releasedAnt = (com.ninni.spawn.entity.Ant)newAnt;
                if (resourcePos != null && !releasedAnt.hasSavedResourcePos()) {
                    releasedAnt.setSavedResourcePos(resourcePos);
                }
                if (antState == AntState.RESOURCE_DELIVERED) {
                    releasedAnt.setHasResource(false);
                    int i = (Integer)state.m_61143_((Property)AnthillBlock.RESOURCE_LEVEL);
                    if (state.m_60734_() instanceof AnthillBlock && i < 3) {
                        world.m_46597_(pos, (BlockState)state.m_61124_((Property)AnthillBlock.RESOURCE_LEVEL, (Comparable)Integer.valueOf(i + 1)));
                    }
                }
                AnthillBlockEntity.ageAnt(Ant.ticksInAnthill, releasedAnt);
                if (entities != null) {
                    entities.add((Entity)releasedAnt);
                }
            } else {
                return false;
            }
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 1.0;
            double z = (double)pos.m_123343_() + 0.5;
            releasedAnt.m_7678_(x, y, z, releasedAnt.m_146908_(), releasedAnt.m_146909_());
            world.m_5594_(null, pos, (SoundEvent)SpawnSoundEvents.ANTHILL_EXIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)releasedAnt, (BlockState)world.m_8055_(pos)));
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                releasedAnt.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(releasedAnt.m_20183_()), MobSpawnType.EVENT, null, nbtCompound);
            }
            return world.m_7967_((Entity)releasedAnt);
        }
        return false;
    }

    static void removeIrrelevantNbtKeys(CompoundTag compound) {
        for (String string : IGNORED_ANT_TAGS) {
            compound.m_128473_(string);
        }
    }

    private static void ageAnt(int ticks, com.ninni.spawn.entity.Ant ant) {
        int i = ant.m_146764_();
        if (i < 0) {
            ant.m_146762_(Math.min(0, i + ticks));
        } else if (i > 0) {
            ant.m_146762_(Math.max(0, i - ticks));
        }
    }

    private static void tickAnts(Level world, BlockPos pos, BlockState state, List<Ant> ants, BlockPos resourcePos, boolean hasResource) {
        boolean bl = false;
        Iterator<Ant> iterator = ants.iterator();
        while (iterator.hasNext()) {
            Ant ant = iterator.next();
            if (Ant.ticksInAnthill > ant.minOccupationTicks) {
                AntState antState;
                AntState antState2 = antState = hasResource ? AntState.RESOURCE_DELIVERED : AntState.ANT_RELEASED;
                if (AnthillBlockEntity.releaseAnt(world, pos, state, ant, null, antState, resourcePos)) {
                    bl = true;
                    iterator.remove();
                }
            }
            ++Ant.ticksInAnthill;
        }
        if (bl) {
            AnthillBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, AnthillBlockEntity blockEntity) {
        AnthillBlockEntity.tickAnts(world, pos, state, blockEntity.ants, blockEntity.savedResourcePos, blockEntity.hasResource);
        if (!blockEntity.ants.isEmpty() && world.m_213780_().m_188500_() < 0.005) {
            double d = (double)pos.m_123341_() + 0.5;
            double e = pos.m_123342_();
            double f = (double)pos.m_123343_() + 0.5;
            world.m_6263_(null, d, e, f, (SoundEvent)SpawnSoundEvents.ANTHILL_WORK.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.ants.clear();
        ListTag nbtList = nbt.m_128437_(ANTS_KEY, 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbtCompound = nbtList.m_128728_(i);
            Ant ant = new Ant(nbtCompound.m_128469_(ENTITY_DATA_KEY), nbtCompound.m_128451_(TICKS_IN_ANTHILL_KEY), nbtCompound.m_128451_(MIN_OCCUPATION_TICKS_KEY));
            this.ants.add(ant);
        }
        this.hasResource = nbt.m_128471_("HasResource");
        this.savedResourcePos = null;
        if (nbt.m_128441_("ResourcePos")) {
            this.savedResourcePos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("ResourcePos"));
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_(ANTS_KEY, (Tag)this.getAnts());
        nbt.m_128379_("HasResource", this.hasResource);
        if (this.savedResourcePos != null) {
            nbt.m_128365_("ResourcePos", (Tag)NbtUtils.m_129224_((BlockPos)this.savedResourcePos));
        }
    }

    public ListTag getAnts() {
        ListTag nbtList = new ListTag();
        for (Ant ant : this.ants) {
            CompoundTag nbtCompound = ant.entityData.m_6426_();
            nbtCompound.m_128473_("UUID");
            CompoundTag nbtCompound2 = new CompoundTag();
            nbtCompound2.m_128365_(ENTITY_DATA_KEY, (Tag)nbtCompound);
            nbtCompound2.m_128405_(IGNORED_ANT_TAGS.toString(), Ant.ticksInAnthill);
            nbtCompound2.m_128405_(MIN_OCCUPATION_TICKS_KEY, ant.minOccupationTicks);
            nbtList.add((Object)nbtCompound2);
        }
        return nbtList;
    }

    public static enum AntState {
        RESOURCE_DELIVERED,
        ANT_RELEASED,
        EMERGENCY;

    }

    static class Ant {
        final CompoundTag entityData;
        static int ticksInAnthill;
        final int minOccupationTicks;

        Ant(CompoundTag entityData, int ticksInDwelling, int minOccupationTicks) {
            AnthillBlockEntity.removeIrrelevantNbtKeys(entityData);
            this.entityData = entityData;
            ticksInAnthill = ticksInDwelling;
            this.minOccupationTicks = minOccupationTicks;
        }
    }
}

