/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ninni.spawn.entity.Seahorse;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SeahorseModel<E extends Seahorse>
extends EntityModel<E> {
    public static final String TAIL_BASE = "tail_base";
    public static final String SNOUT = "snout";
    public static final String CREST = "crest";
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart tailBase;
    private final ModelPart tail;
    private final ModelPart leftFin;
    private final ModelPart rightFin;
    private final ModelPart head;
    private final ModelPart snout;
    private final ModelPart crest;

    public SeahorseModel(ModelPart root) {
        this.root = root;
        this.body = this.root.m_171324_("body");
        this.tailBase = this.body.m_171324_(TAIL_BASE);
        this.leftFin = this.body.m_171324_("left_fin");
        this.rightFin = this.body.m_171324_("right_fin");
        this.head = this.body.m_171324_("head");
        this.snout = this.head.m_171324_(SNOUT);
        this.crest = this.head.m_171324_(CREST);
        this.tail = this.tailBase.m_171324_("tail");
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition data = new MeshDefinition();
        PartDefinition root = data.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.5f, -1.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)0.0f));
        PartDefinition tailBase = body.m_171599_(TAIL_BASE, CubeListBuilder.m_171558_().m_171514_(22, 1).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.5f));
        PartDefinition tail = tailBase.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(14, 0).m_171481_(-1.0f, 0.0f, -3.0f, 2.0f, 3.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition leftFin = body.m_171599_("left_fin", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -1.0f, 0.0f, 0.0f, 2.0f, 1.0f), PartPose.m_171419_((float)-1.5f, (float)1.0f, (float)0.0f));
        PartDefinition rightFin = body.m_171599_("right_fin", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -1.0f, 0.0f, 0.0f, 2.0f, 1.0f), PartPose.m_171419_((float)1.5f, (float)1.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-2.0f, -2.0f, -2.5f, 4.0f, 3.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition snout = head.m_171599_(SNOUT, CubeListBuilder.m_171558_().m_171514_(16, 17).m_171481_(-0.5f, -0.5f, -3.0f, 1.0f, 1.0f, 3.0f), PartPose.m_171419_((float)0.1f, (float)0.5f, (float)-2.5f));
        PartDefinition crest = head.m_171599_(CREST, CubeListBuilder.m_171558_().m_171514_(0, 4).m_171481_(0.0f, -4.5f, -2.5f, 0.0f, 5.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)data, (int)32, (int)32);
    }

    public void setupAnim(E entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        float speed = 2.0f;
        float degree = 1.0f;
        if (entity.m_5842_()) {
            this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
        } else {
            this.head.f_104203_ = 0.0f;
            this.head.f_104204_ = 0.0f;
        }
        this.body.f_104201_ = Mth.m_14089_((float)(animationProgress * speed * 0.1f)) * degree * 0.5f * 0.25f + 17.0f;
        this.leftFin.f_104204_ = Mth.m_14089_((float)(animationProgress * speed * 0.4f)) * degree * -1.8f * 0.25f - 0.6f;
        this.rightFin.f_104204_ = Mth.m_14089_((float)(animationProgress * speed * 0.4f)) * degree * 1.8f * 0.25f + 0.6f;
        this.tailBase.f_104203_ = Mth.m_14089_((float)(-1.0f + animationProgress * speed * 0.1f)) * degree * 0.6f * 0.25f;
        this.tail.f_104203_ = Mth.m_14089_((float)(-2.0f + animationProgress * speed * 0.1f)) * degree * 0.6f * 0.25f;
        this.body.f_104203_ = Mth.m_14089_((float)(animationProgress * speed * 0.1f)) * degree * 0.4f * 0.25f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j, float f, float g, float h, float k) {
        this.root.m_104306_(poseStack, vertexConsumer, i, j, f, g, h, k);
    }
}

