/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.entity;

import com.ninni.spawn.SpawnTags;
import com.ninni.spawn.client.inventory.HamsterInventoryMenu;
import com.ninni.spawn.entity.variant.HamsterVariant;
import com.ninni.spawn.network.OpenHamsterScreenPacket;
import com.ninni.spawn.network.SpawnNetworkHandler;
import com.ninni.spawn.registry.SpawnCriteriaTriggers;
import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.registry.SpawnSoundEvents;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class Hamster
extends TamableAnimal
implements InventoryCarrier,
ContainerListener,
HasCustomInventoryScreen {
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> PUFF_TICKS = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    static final Predicate<ItemEntity> ALLOWED_ITEMS = itemEntity -> !itemEntity.m_32063_() && itemEntity.m_6084_();
    public final SimpleContainer inventory = new SimpleContainer(12);

    public Hamster(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new HamsterMoveControl();
        this.m_21553_(true);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        HamsterVariant[] variants = HamsterVariant.values();
        HamsterVariant variant = (HamsterVariant)((Object)Util.m_214670_((Object[])variants, (RandomSource)serverLevelAccessor.m_213780_()));
        this.setVariant(variant);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Hamster.class, false, this::getTerritorialTarget));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 24.0f, 1.1, 1.3));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 24.0f, 1.1, 1.3));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 7.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_204132_(SpawnTags.HAMSTER_TEMPTS), false));
        this.f_21345_.m_25352_(9, (Goal)new HamsterSearchForItemsGoal());
        this.f_21345_.m_25352_(10, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(12, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(13, (Goal)new StandGoal());
    }

    private boolean getTerritorialTarget(LivingEntity livingEntity) {
        Hamster hamster;
        return livingEntity instanceof Hamster && (hamster = (Hamster)livingEntity).m_21824_() && !hamster.m_21825_() && !this.m_21825_() && this.m_21824_() && hamster.m_21805_() == this.m_21805_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22276_, 6.0);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(SpawnTags.HAMSTER_TEMPTS);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (!this.m_9236_().f_46443_ && player.m_36341_() && this.m_21830_((LivingEntity)player) && !this.m_6162_()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SpawnCriteriaTriggers.OPEN_HAMSTER_INVENTORY.trigger(serverPlayer);
            }
            this.m_213583_(player);
            return InteractionResult.SUCCESS;
        }
        if (this.m_9236_().f_46443_) {
            boolean bl = this.m_21830_((LivingEntity)player) || this.m_21824_() || itemStack.m_204117_(SpawnTags.HAMSTER_FEEDS) && !this.m_21824_();
            return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_6898_(itemStack) && this.m_21223_() < this.m_21233_()) {
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                this.m_5634_(4.0f);
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionResult = super.m_6071_(player, interactionHand);
            if (interactionResult.m_19077_() && !this.m_6162_() || !this.m_21830_((LivingEntity)player)) {
                return interactionResult;
            }
            this.m_21839_(!this.m_21827_());
            this.f_20899_ = false;
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            return InteractionResult.SUCCESS;
        }
        if (!itemStack.m_204117_(SpawnTags.HAMSTER_FEEDS)) {
            return super.m_6071_(player, interactionHand);
        }
        if (!player.m_150110_().f_35937_) {
            this.m_5496_((SoundEvent)SpawnSoundEvents.HAMSTER_EAT.get(), 1.0f, 1.0f);
            itemStack.m_41774_(1);
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            this.m_5496_((SoundEvent)SpawnSoundEvents.HAMSTER_EAT.get(), 1.0f, 1.0f);
            this.m_21828_(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.m_21839_(true);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
            return InteractionResult.SUCCESS;
        }
        this.m_9236_().m_7605_((Entity)this, (byte)6);
        return InteractionResult.SUCCESS;
    }

    public float getPuffTicks() {
        return ((Float)this.f_19804_.m_135370_(PUFF_TICKS)).floatValue();
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            float puffTicks = ((Float)this.f_19804_.m_135370_(PUFF_TICKS)).floatValue();
            float change = 0.2f;
            if (!this.m_35311_().m_216874_(ItemStack::m_41619_)) {
                if (puffTicks < 1.0f) {
                    this.f_19804_.m_135381_(PUFF_TICKS, (Object)Float.valueOf(puffTicks + change));
                }
            } else if (puffTicks > 0.0f) {
                this.f_19804_.m_135381_(PUFF_TICKS, (Object)Float.valueOf(puffTicks - change));
            }
        }
        super.m_8119_();
    }

    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    protected void m_7581_(ItemEntity itemEntity) {
        this.m_5496_((SoundEvent)SpawnSoundEvents.HAMSTER_EAT.get(), 1.0f, 1.0f);
        InventoryCarrier.m_219611_((Mob)this, (InventoryCarrier)this, (ItemEntity)itemEntity);
    }

    protected void m_5907_() {
        super.m_5907_();
        this.inventory.m_19195_().forEach(arg_0 -> ((Hamster)this).m_19983_(arg_0));
        ItemStack itemStack = this.m_6844_(EquipmentSlot.MAINHAND);
        if (!itemStack.m_41619_() && !EnchantmentHelper.m_44924_((ItemStack)itemStack)) {
            this.m_19983_(itemStack);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
    }

    protected int m_5639_(float f, float g) {
        return super.m_5639_(f, g) - 10;
    }

    boolean canMove() {
        return !this.isStanding() && !this.m_21825_() && !this.m_6107_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)HamsterVariant.RUSSIAN.id());
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(PUFF_TICKS, (Object)Float.valueOf(0.0f));
    }

    public void m_7105_(boolean bl) {
        super.m_7105_(bl);
        if (bl) {
            this.m_21051_(Attributes.f_22276_).m_22100_(12.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(6.0);
        }
    }

    public boolean isStanding() {
        return this.getFlag(1);
    }

    public void setStanding(boolean bl) {
        this.setFlag(1, bl);
    }

    private void setFlag(int i, boolean bl) {
        if (bl) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) | i)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & ~i)));
        }
    }

    private boolean getFlag(int i) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & i) != 0;
    }

    public HamsterVariant getVariant() {
        return HamsterVariant.byId((Integer)this.f_19804_.m_135370_(VARIANT));
    }

    public void setVariant(HamsterVariant variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant.id());
    }

    public void m_5757_(Container container) {
    }

    public void m_213583_(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.f_36096_ != serverPlayer.f_36095_) {
                serverPlayer.m_6915_();
            }
            serverPlayer.m_9217_();
            SpawnNetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new OpenHamsterScreenPacket(serverPlayer.f_8940_, this.m_35311_().m_6643_(), this.m_19879_()));
            serverPlayer.f_36096_ = new HamsterInventoryMenu(serverPlayer.f_8940_, serverPlayer.m_150109_(), (Container)this.inventory, this);
            serverPlayer.m_143399_(serverPlayer.f_36096_);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)serverPlayer, serverPlayer.f_36096_));
        }
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SpawnSoundEvents.HAMSTER_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.isStanding() ? (SoundEvent)SpawnSoundEvents.HAMSTER_AMBIENT_CALL.get() : (SoundEvent)SpawnSoundEvents.HAMSTER_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SpawnSoundEvents.HAMSTER_DEATH.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_((SoundEvent)SpawnSoundEvents.HAMSTER_STEP.get(), 0.15f, 1.0f);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        this.m_252802_(compoundTag);
        compoundTag.m_128405_("Variant", this.getVariant().id());
        compoundTag.m_128379_("Standing", this.isStanding());
        ListTag listTag = new ListTag();
        for (int i = 2; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemStack = this.inventory.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            CompoundTag compoundTag2 = new CompoundTag();
            compoundTag2.m_128344_("Slot", (byte)i);
            itemStack.m_41739_(compoundTag2);
            listTag.add((Object)compoundTag2);
        }
        compoundTag.m_128365_("Items", (Tag)listTag);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.m_253224_(compoundTag);
        this.setVariant(HamsterVariant.byId(compoundTag.m_128451_("Variant")));
        this.setStanding(compoundTag.m_128471_("Standing"));
        ListTag listTag = compoundTag.m_128437_("Items", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag2 = listTag.m_128728_(i);
            int j = compoundTag2.m_128445_("Slot") & 0xFF;
            if (j < 2 || j >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundTag2));
        }
    }

    public static boolean canSpawn(EntityType<Hamster> hamsterEntityType, ServerLevelAccessor world, MobSpawnType mobSpawnType, BlockPos pos, RandomSource randomSource) {
        return world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184228_) && Animal.m_186209_((BlockAndTintGetter)world, (BlockPos)pos);
    }

    @Nullable
    public Hamster getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        Hamster hamster = (Hamster)((EntityType)SpawnEntityType.HAMSTER.get()).m_20615_((Level)serverLevel);
        if (hamster != null && ageableMob instanceof Hamster) {
            Hamster hamster2 = (Hamster)ageableMob;
            if (this.f_19796_.m_188499_()) {
                hamster.setVariant(this.getVariant());
            } else {
                hamster.setVariant(hamster2.getVariant());
            }
            if (this.m_21824_()) {
                hamster.m_21816_(this.m_21805_());
                hamster.m_7105_(true);
            }
        }
        return hamster;
    }

    class HamsterMoveControl
    extends MoveControl {
        public HamsterMoveControl() {
            super((Mob)Hamster.this);
        }

        public void m_8126_() {
            if (Hamster.this.canMove()) {
                super.m_8126_();
            }
        }
    }

    class HamsterSearchForItemsGoal
    extends Goal {
        public HamsterSearchForItemsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!Hamster.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                return false;
            }
            if (Hamster.this.m_5448_() != null || Hamster.this.m_21188_() != null) {
                return false;
            }
            if (!Hamster.this.canMove()) {
                return false;
            }
            if (Hamster.this.m_217043_().m_188503_(HamsterSearchForItemsGoal.m_186073_((int)10)) != 0) {
                return false;
            }
            List list = Hamster.this.m_9236_().m_6443_(ItemEntity.class, Hamster.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            return !list.isEmpty() && Hamster.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
        }

        public void m_8037_() {
            List list = Hamster.this.m_9236_().m_6443_(ItemEntity.class, Hamster.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            ItemStack itemStack = Hamster.this.m_6844_(EquipmentSlot.MAINHAND);
            if (itemStack.m_41619_() && !list.isEmpty()) {
                Hamster.this.m_21573_().m_5624_((Entity)list.get(0), 1.0);
            }
        }

        public void m_8056_() {
            List list = Hamster.this.m_9236_().m_6443_(ItemEntity.class, Hamster.this.m_20191_().m_82377_(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (!list.isEmpty()) {
                Hamster.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    class StandGoal
    extends Goal {
        private double relX;
        private double relZ;
        private int lookTime;
        private int looksRemaining;

        public StandGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return Hamster.this.m_21188_() == null && Hamster.this.m_217043_().m_188501_() < 0.02f && Hamster.this.m_5448_() == null && Hamster.this.m_21573_().m_26571_();
        }

        public boolean m_8045_() {
            return this.looksRemaining > 0;
        }

        public void m_8056_() {
            this.resetLook();
            this.looksRemaining = 2 + Hamster.this.m_217043_().m_188503_(3);
            Hamster.this.setStanding(true);
            Hamster.this.m_21573_().m_26573_();
        }

        public void m_8041_() {
            Hamster.this.setStanding(false);
        }

        public void m_8037_() {
            --this.lookTime;
            if (this.lookTime <= 0) {
                --this.looksRemaining;
                this.resetLook();
            }
            Hamster.this.m_21563_().m_24950_(Hamster.this.m_20185_() + this.relX, Hamster.this.m_20188_(), Hamster.this.m_20189_() + this.relZ, (float)Hamster.this.m_8085_(), (float)Hamster.this.m_8132_());
        }

        private void resetLook() {
            double d = Math.PI * 2 * Hamster.this.m_217043_().m_188500_();
            this.relX = Math.cos(d);
            this.relZ = Math.sin(d);
            this.lookTime = this.m_183277_(80 + Hamster.this.m_217043_().m_188503_(20));
        }
    }
}

