/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.entity;

import com.ninni.spawn.entity.variant.SeahorseVariant;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnSoundEvents;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Seahorse
extends AbstractFish
implements Bucketable {
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Seahorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final String BUCKET_VARIANT_TAG = "BucketVariantTag";

    public Seahorse(EntityType<? extends Seahorse> type, Level world) {
        super(type, world);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (mobSpawnType != MobSpawnType.BUCKET) {
            SeahorseVariant[] variants = SeahorseVariant.values();
            SeahorseVariant variant = (SeahorseVariant)((Object)Util.m_214670_((Object[])variants, (RandomSource)serverLevelAccessor.m_213780_()));
            this.setVariant(variant);
        }
        if (mobSpawnType == MobSpawnType.BUCKET && compoundTag != null && compoundTag.m_128425_(BUCKET_VARIANT_TAG, 3)) {
            this.setVariant(SeahorseVariant.byId(compoundTag.m_128451_(BUCKET_VARIANT_TAG)));
            return spawnGroupData;
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)SeahorseVariant.ORANGE.id());
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.65).m_22268_(Attributes.f_22276_, 4.0);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * 0.95f;
    }

    public SeahorseVariant getVariant() {
        return SeahorseVariant.byId((Integer)this.f_19804_.m_135370_(VARIANT));
    }

    public void setVariant(SeahorseVariant variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant.id());
    }

    public ItemStack m_28282_() {
        return ((Item)SpawnItems.SEAHORSE_BUCKET.get()).m_7968_();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SpawnSoundEvents.SEAHORSE_DEATH.get();
    }

    protected SoundEvent m_5501_() {
        return (SoundEvent)SpawnSoundEvents.FISH_SWIM.get();
    }

    @Nullable
    public SoundEvent m_7515_() {
        return this.m_5842_() ? (this.f_19796_.m_188503_(3) == 0 ? (SoundEvent)SpawnSoundEvents.SEAHORSE_GROWL.get() : (SoundEvent)SpawnSoundEvents.SEAHORSE_CLICK.get()) : null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SpawnSoundEvents.SEAHORSE_HURT.get();
    }

    protected SoundEvent m_5699_() {
        return (SoundEvent)SpawnSoundEvents.FISH_FLOP.get();
    }

    public void m_6872_(ItemStack itemStack) {
        super.m_6872_(itemStack);
        CompoundTag compoundTag = itemStack.m_41784_();
        compoundTag.m_128405_(BUCKET_VARIANT_TAG, this.getVariant().id());
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Variant", this.getVariant().id());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setVariant(SeahorseVariant.byId(compoundTag.m_128451_("Variant")));
    }
}

