/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.entity;

import com.ninni.spawn.entity.Tuna;
import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnParticles;
import com.ninni.spawn.registry.SpawnSoundEvents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class TunaEgg
extends Mob
implements Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(TunaEgg.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> HATCH_TICKS = SynchedEntityData.m_135353_(TunaEgg.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final String BUCKET_VARIANT_TAG = "BucketVariantTag";
    public long lastHit;

    public TunaEgg(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (mobSpawnType == MobSpawnType.BUCKET && compoundTag != null && compoundTag.m_128425_(BUCKET_VARIANT_TAG, 3)) {
            this.setHatchTicks(compoundTag.m_128451_(BUCKET_VARIANT_TAG));
            return spawnGroupData;
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        long l = this.m_9236_().m_46467_();
        boolean bl = damageSource.m_7640_() instanceof AbstractArrow;
        if (l - this.lastHit <= 5L || bl) {
            this.broken();
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)32);
            this.m_146852_(GameEvent.f_223706_, damageSource.m_7639_());
            this.m_216990_((SoundEvent)SpawnSoundEvents.TUNA_EGG_HIT.get());
            this.lastHit = l;
        }
        return true;
    }

    public void m_6872_(ItemStack itemStack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)itemStack);
        CompoundTag compoundTag = itemStack.m_41784_();
        compoundTag.m_128405_(BUCKET_VARIANT_TAG, this.getHatchTicks());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(HATCH_TICKS, (Object)6000);
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean bl) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)bl);
    }

    public int getHatchTicks() {
        return (Integer)this.f_19804_.m_135370_(HATCH_TICKS);
    }

    public void setHatchTicks(int hatchTicks) {
        this.f_19804_.m_135381_(HATCH_TICKS, (Object)hatchTicks);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("FromBucket", this.m_27487_());
        compoundTag.m_128405_("HatchTicks", this.getHatchTicks());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.m_27497_(compoundTag.m_128471_("FromBucket"));
        this.setHatchTicks(compoundTag.m_128451_("HatchTicks"));
    }

    protected void handleAirSupply(int i) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(i - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.broken();
            }
        } else {
            this.m_20301_(300);
        }
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(i);
    }

    public void m_8107_() {
        Level level;
        super.m_8107_();
        if (this.getHatchTicks() > 0) {
            this.setHatchTicks(this.getHatchTicks() - 1);
        }
        if (this.getHatchTicks() == 0 && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.hatch(serverLevel);
        }
    }

    public void broken() {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SpawnSoundEvents.TUNA_EGG_BROKEN.get(), this.m_5720_(), 1.0f, 1.0f);
        if (this.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)SpawnParticles.TUNA_EGG.get()), this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 10, (double)this.m_20205_(), (double)this.m_20206_(), (double)this.m_20205_(), 0.5);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        return Bucketable.m_148828_((Player)player, (InteractionHand)interactionHand, (LivingEntity)this).orElse(super.m_6071_(player, interactionHand));
    }

    public void hatch(ServerLevel level) {
        Tuna tuna = (Tuna)((EntityType)SpawnEntityType.TUNA.get()).m_20615_((Level)level);
        assert (tuna != null);
        tuna.m_6863_(true);
        tuna.m_21530_();
        tuna.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
        level.m_7967_((Entity)tuna);
        this.broken();
    }

    public void m_142278_(CompoundTag compoundTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)compoundTag);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SpawnSoundEvents.TUNA_EGG_HIT.get();
    }

    public SoundEvent m_142623_() {
        return (SoundEvent)SpawnSoundEvents.BUCKET_FILL_TUNA_EGG.get();
    }

    public ItemStack m_28282_() {
        return ((Item)SpawnItems.TUNA_EGG_BUCKET.get()).m_7968_();
    }
}

