/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.events;

import com.google.common.collect.Lists;
import com.ninni.spawn.client.model.AnglerFishModel;
import com.ninni.spawn.client.model.AntModel;
import com.ninni.spawn.client.model.HamsterModel;
import com.ninni.spawn.client.model.SeahorseModel;
import com.ninni.spawn.client.model.SnailModel;
import com.ninni.spawn.client.model.TunaEggModel;
import com.ninni.spawn.client.model.TunaModel;
import com.ninni.spawn.client.particles.TunaEggParticle;
import com.ninni.spawn.client.renderer.entity.AnglerFishRenderer;
import com.ninni.spawn.client.renderer.entity.AntRenderer;
import com.ninni.spawn.client.renderer.entity.HamsterRenderer;
import com.ninni.spawn.client.renderer.entity.SeahorseRenderer;
import com.ninni.spawn.client.renderer.entity.SnailRenderer;
import com.ninni.spawn.client.renderer.entity.TunaEggRenderer;
import com.ninni.spawn.client.renderer.entity.TunaRenderer;
import com.ninni.spawn.registry.SpawnEntityModelLayers;
import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnParticles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.client.particle.GlowParticle;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="spawn", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    private static final Function<ItemLike, ItemStack> FUNCTION = ItemStack::new;

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(SpawnEntityModelLayers.ANGLER_FISH, AnglerFishModel::getLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.ANGLER_FISH_DEFLATED, AnglerFishModel::getDeflatedLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.TUNA, TunaModel::getLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.TUNA_EGG, TunaEggModel::getLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.SEAHORSE, SeahorseModel::getLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.SNAIL, SnailModel::getLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.HAMSTER, HamsterModel::getLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.HAMSTER_STANDING, HamsterModel::getStandingLayerDefinition);
        event.registerLayerDefinition(SpawnEntityModelLayers.ANT, AntModel::getLayerDefinition);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)SpawnEntityType.ANGLER_FISH.get(), AnglerFishRenderer::new);
        event.registerEntityRenderer((EntityType)SpawnEntityType.TUNA.get(), TunaRenderer::new);
        event.registerEntityRenderer((EntityType)SpawnEntityType.TUNA_EGG.get(), TunaEggRenderer::new);
        event.registerEntityRenderer((EntityType)SpawnEntityType.SEAHORSE.get(), SeahorseRenderer::new);
        event.registerEntityRenderer((EntityType)SpawnEntityType.SNAIL.get(), SnailRenderer::new);
        event.registerEntityRenderer((EntityType)SpawnEntityType.HAMSTER.get(), HamsterRenderer::new);
        event.registerEntityRenderer((EntityType)SpawnEntityType.ANT.get(), AntRenderer::new);
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)SpawnParticles.ANGLER_FISH_LANTERN_GLOW.get(), GlowParticle.GlowSquidProvider::new);
        event.registerSpriteSet((ParticleType)SpawnParticles.TUNA_EGG.get(), TunaEggParticle.Factory::new);
    }

    private static void addAfter(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike after, ItemLike ... block) {
        ArrayList stream = Lists.newArrayList(Arrays.stream(block).toList());
        Collections.reverse(stream);
        stream.forEach(blk -> ClientEvents.addAfter(map, after, blk));
    }

    private static void addBefore(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike before, ItemLike ... block) {
        ArrayList stream = Lists.newArrayList(Arrays.stream(block).toList());
        Collections.reverse(stream);
        stream.forEach(blk -> ClientEvents.addBefore(map, before, blk));
    }

    private static void addAfter(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike after, ItemLike block) {
        map.putAfter((Object)FUNCTION.apply(after), (Object)FUNCTION.apply(block), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private static void addBefore(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike before, ItemLike block) {
        map.putBefore((Object)FUNCTION.apply(before), (Object)FUNCTION.apply(block), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private static void accept(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> map, ItemLike block) {
        map.put((Object)new ItemStack(block), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    @SubscribeEvent
    public static void buildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
        MutableHashedLinkedMap entries = event.getEntries();
        ResourceKey tabKey = event.getTabKey();
        if (tabKey.equals((Object)CreativeModeTabs.f_256788_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_150992_, (ItemLike)SpawnItems.BIG_SNAIL_SHELL.get(), (ItemLike)SpawnItems.SNAIL_SHELL_TILES.get(), (ItemLike)SpawnItems.SNAIL_SHELL_TILE_STAIRS.get(), (ItemLike)SpawnItems.SNAIL_SHELL_TILE_SLAB.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_271474_, (ItemLike)SpawnItems.ROTTEN_LOG.get(), (ItemLike)SpawnItems.ROTTEN_WOOD.get(), (ItemLike)SpawnItems.STRIPPED_ROTTEN_LOG.get(), (ItemLike)SpawnItems.STRIPPED_ROTTEN_WOOD.get(), (ItemLike)SpawnItems.ROTTEN_PLANKS.get(), (ItemLike)SpawnItems.CRACKED_ROTTEN_PLANKS.get(), (ItemLike)SpawnItems.ROTTEN_STAIRS.get(), (ItemLike)SpawnItems.ROTTEN_SLAB.get(), (ItemLike)SpawnItems.ROTTEN_FENCE.get(), (ItemLike)SpawnItems.ROTTEN_FENCE_GATE.get(), (ItemLike)SpawnItems.ROTTEN_DOOR.get(), (ItemLike)SpawnItems.ROTTEN_TRAPDOOR.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_256869_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42457_, (ItemLike)SpawnItems.TUNA_EGG_BUCKET.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42458_, (ItemLike)SpawnItems.ANGLER_FISH_BUCKET.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42459_, (ItemLike)SpawnItems.SEAHORSE_BUCKET.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42455_, (ItemLike)SpawnItems.ANT_PUPA.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_283830_, (ItemLike)SpawnItems.MUSIC_DISC_ROT.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_257028_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42788_, (ItemLike)SpawnItems.MUCUS_BLOCK.get(), (ItemLike)SpawnItems.GHOSTLY_MUCUS_BLOCK.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_256776_)) {
            ClientEvents.addBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42207_, (ItemLike)SpawnItems.SUNFLOWER.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42733_, (ItemLike)SpawnItems.SUNFLOWER_SEEDS.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42788_, (ItemLike)SpawnItems.MUCUS_BLOCK.get(), (ItemLike)SpawnItems.BIG_SNAIL_SHELL.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_220223_, (ItemLike)SpawnItems.SNAIL_EGGS.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42789_, (ItemLike)SpawnItems.ANTHILL.get(), (ItemLike)SpawnItems.ROTTEN_LOG_ANTHILL.get(), (ItemLike)SpawnItems.ANT_MOUND.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_271090_, (ItemLike)SpawnItems.ROTTEN_LOG.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_41866_, (ItemLike)SpawnItems.FALLEN_LEAVES.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_256791_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_151025_, (ItemLike)SpawnItems.MUCUS.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_271478_, (ItemLike)SpawnItems.POTTED_SWEET_BERRIES.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42785_, (ItemLike)SpawnItems.ANTHILL.get(), (ItemLike)SpawnItems.ROTTEN_LOG_ANTHILL.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42786_, (ItemLike)SpawnItems.ANT_FARM.get(), (ItemLike)SpawnItems.ANT_MOUND.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_256839_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42575_, (ItemLike)SpawnItems.ROASTED_SUNFLOWER_SEEDS.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42529_, (ItemLike)SpawnItems.ESCARGOT.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42531_, (ItemLike)SpawnItems.TUNA_CHUNK.get(), (ItemLike)SpawnItems.COOKED_TUNA_CHUNK.get(), (ItemLike)SpawnItems.ANGLER_FISH.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42406_, (ItemLike)SpawnItems.TUNA_SANDWICH.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_256968_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_279650_, (ItemLike)SpawnItems.CROWN_POTTERY_SHERD.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_279636_, (ItemLike)SpawnItems.SPADE_POTTERY_SHERD.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42784_, (ItemLike)SpawnItems.SNAIL_SHELL.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42355_, (ItemLike)SpawnItems.MUCUS.get());
        }
        if (tabKey.equals((Object)CreativeModeTabs.f_256731_)) {
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_220212_, (ItemLike)SpawnItems.ANGLER_FISH_SPAWN_EGG.get(), (ItemLike)SpawnItems.ANT_SPAWN_EGG.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42638_, (ItemLike)SpawnItems.SEAHORSE_SPAWN_EGG.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42644_, (ItemLike)SpawnItems.SNAIL_SPAWN_EGG.get());
            ClientEvents.addAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42598_, (ItemLike)SpawnItems.TUNA_SPAWN_EGG.get());
        }
    }
}

