/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.registry;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.ninni.spawn.mixin.ComposterBlockAccessor;
import com.ninni.spawn.mixin.FireBlockAccessor;
import com.ninni.spawn.registry.SpawnBlocks;
import com.ninni.spawn.registry.SpawnDecoratedPotPatterns;
import com.ninni.spawn.registry.SpawnItems;
import java.util.Map;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;

public class SpawnVanillaIntegration {
    public static void serverInit() {
        SpawnVanillaIntegration.registerStrippables();
        SpawnVanillaIntegration.registerFlammables();
        SpawnVanillaIntegration.registerCompostables();
        SpawnVanillaIntegration.registerPotPatterns();
    }

    private static void registerPotPatterns() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.putAll(DecoratedPotPatterns.f_271367_);
        map.put((Object)((Item)SpawnItems.CROWN_POTTERY_SHERD.get()), (Object)SpawnDecoratedPotPatterns.CROWN.getKey());
        map.put((Object)((Item)SpawnItems.SPADE_POTTERY_SHERD.get()), (Object)SpawnDecoratedPotPatterns.SPADE.getKey());
        DecoratedPotPatterns.f_271367_ = map.build();
    }

    private static void registerStrippables() {
        AxeItem.f_150683_ = Maps.newHashMap((Map)AxeItem.f_150683_);
        AxeItem.f_150683_.put((Block)SpawnBlocks.ROTTEN_LOG.get(), (Block)SpawnBlocks.STRIPPED_ROTTEN_LOG.get());
        AxeItem.f_150683_.put((Block)SpawnBlocks.ROTTEN_WOOD.get(), (Block)SpawnBlocks.STRIPPED_ROTTEN_WOOD.get());
    }

    private static void registerFlammables() {
        FireBlockAccessor accessor = (FireBlockAccessor)Blocks.f_50083_;
        accessor.callSetFlammable((Block)SpawnBlocks.FALLEN_LEAVES.get(), 60, 100);
        accessor.callSetFlammable((Block)SpawnBlocks.SUNFLOWER.get(), 60, 100);
        accessor.callSetFlammable((Block)SpawnBlocks.ROTTEN_LOG.get(), 5, 5);
        accessor.callSetFlammable((Block)SpawnBlocks.ROTTEN_WOOD.get(), 5, 5);
        accessor.callSetFlammable((Block)SpawnBlocks.STRIPPED_ROTTEN_LOG.get(), 5, 5);
        accessor.callSetFlammable((Block)SpawnBlocks.STRIPPED_ROTTEN_WOOD.get(), 5, 5);
        accessor.callSetFlammable((Block)SpawnBlocks.CRACKED_ROTTEN_PLANKS.get(), 5, 20);
        accessor.callSetFlammable((Block)SpawnBlocks.ROTTEN_PLANKS.get(), 5, 20);
        accessor.callSetFlammable((Block)SpawnBlocks.ROTTEN_SLAB.get(), 5, 20);
        accessor.callSetFlammable((Block)SpawnBlocks.ROTTEN_STAIRS.get(), 5, 20);
        accessor.callSetFlammable((Block)SpawnBlocks.ROTTEN_FENCE.get(), 5, 20);
        accessor.callSetFlammable((Block)SpawnBlocks.ROTTEN_FENCE_GATE.get(), 5, 20);
    }

    private static void registerCompostables() {
        ComposterBlockAccessor.callAdd(0.25f, (ItemLike)SpawnItems.FALLEN_LEAVES.get());
        ComposterBlockAccessor.callAdd(0.65f, (ItemLike)SpawnItems.SUNFLOWER.get());
        ComposterBlockAccessor.callAdd(0.8f, (ItemLike)SpawnItems.TUNA_SANDWICH.get());
        ComposterBlockAccessor.callAdd(0.8f, (ItemLike)SpawnItems.SNAIL_SHELL.get());
        ComposterBlockAccessor.callAdd(1.0f, (ItemLike)SpawnItems.ROTTEN_LOG.get());
        ComposterBlockAccessor.callAdd(1.0f, (ItemLike)SpawnItems.ROTTEN_WOOD.get());
        ComposterBlockAccessor.callAdd(1.0f, (ItemLike)SpawnItems.STRIPPED_ROTTEN_LOG.get());
        ComposterBlockAccessor.callAdd(1.0f, (ItemLike)SpawnItems.STRIPPED_ROTTEN_WOOD.get());
        ComposterBlockAccessor.callAdd(1.0f, (ItemLike)SpawnItems.CRACKED_ROTTEN_PLANKS.get());
        ComposterBlockAccessor.callAdd(1.0f, (ItemLike)SpawnItems.ROTTEN_PLANKS.get());
    }
}

