/*
 * Decompiled with CFR 0.152.
 */
package net.cyber_rat.extra_compat.core.registry.forge.sniffsweapons;

import net.cyber_rat.extra_compat.ExtraCompat;
import net.cyber_rat.extra_compat.core.registry.factory.SWItemFactory;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.registries.RegistryObject;
import quek.undergarden.registry.UGEffects;
import quek.undergarden.registry.UGItemTiers;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGTags;

public class SWUndergardenExtraItems {
    public static final SWItemFactory ITEM_FACTORY = new SWItemFactory();
    public static final RegistryObject<? extends SwordItem> CLOGGRUM_GREATSWORD = ITEM_FACTORY.createGreatSword("cloggrum_great_sword", (Tier)UGItemTiers.CLOGGRUM, 6, -2.9f, new Item.Properties());
    public static final RegistryObject<? extends AxeItem> CLOGGRUM_GREAT_AXE = ITEM_FACTORY.createGreatAxe("cloggrum_great_axe", (Tier)UGItemTiers.CLOGGRUM, 8, -3.2f, new Item.Properties());
    public static final RegistryObject<? extends SwordItem> FORGOTTEN_GREATSWORD = ITEM_FACTORY.createForgottenGreatSword("forgotten_great_sword", (Tier)UGItemTiers.CLOGGRUM, 6, -2.9f, new Item.Properties().m_41497_(UGItems.FORGOTTEN));
    public static final RegistryObject<? extends AxeItem> FORGOTTEN_GREAT_AXE = ITEM_FACTORY.createForgottenGreatAxe("forgotten_great_axe", (Tier)UGItemTiers.CLOGGRUM, 8, -3.2f, new Item.Properties().m_41497_(UGItems.FORGOTTEN));
    public static final RegistryObject<? extends SwordItem> FROSTSTEEL_GREATSWORD = ITEM_FACTORY.createFroststeelGreatSword("froststeel_great_sword", (Tier)UGItemTiers.FROSTSTEEL, 4, -2.9f, new Item.Properties());
    public static final RegistryObject<? extends AxeItem> FROSTSTEEL_GREAT_AXE = ITEM_FACTORY.createFroststeelGreatAxe("froststeel_great_axe", (Tier)UGItemTiers.FROSTSTEEL, 6, -2.9f, new Item.Properties());
    public static final RegistryObject<? extends SwordItem> UTHERIUM_GREATSWORD = ITEM_FACTORY.createUtheriumGreatSword("utherium_great_sword", (Tier)UGItemTiers.UTHERIUM, 5, -2.9f, new Item.Properties());
    public static final RegistryObject<? extends AxeItem> UTHERIUM_GREAT_AXE = ITEM_FACTORY.createUtheriumGreatAxe("utherium_great_axe", (Tier)UGItemTiers.UTHERIUM, 7, -2.9f, new Item.Properties());

    public static void setupToolEvents() {
        MinecraftForge.EVENT_BUS.addListener(SWUndergardenExtraItems::SWforgottenAttackEvent);
        MinecraftForge.EVENT_BUS.addListener(SWUndergardenExtraItems::SWforgottenDigEvent);
        MinecraftForge.EVENT_BUS.addListener(SWUndergardenExtraItems::SWfroststeelAttackEvent);
        MinecraftForge.EVENT_BUS.addListener(SWUndergardenExtraItems::SWutheriumAttackEvent);
    }

    private static void SWforgottenAttackEvent(LivingHurtEvent event) {
        Player player;
        Entity source = event.getSource().m_7639_();
        float damage = event.getAmount();
        if (source instanceof Player && (player = (Player)source).m_21205_().m_41720_() == FORGOTTEN_GREATSWORD.get() && BuiltInRegistries.f_256780_.m_7981_((Object)event.getEntity().m_6095_()).m_135827_().equals("undergarden") && !event.getEntity().m_6095_().m_204039_(Tags.EntityTypes.BOSSES)) {
            event.setAmount(damage * 1.5f);
        }
    }

    private static void SWforgottenDigEvent(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        BlockState state = event.getState();
        if (player.m_21205_().m_41720_() == FORGOTTEN_GREAT_AXE.get() && state != null && BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()).m_135827_().equals("undergarden")) {
            event.setNewSpeed(event.getOriginalSpeed() * 1.5f);
        }
    }

    private static void SWfroststeelAttackEvent(LivingHurtEvent event) {
        Entity source = event.getSource().m_7639_();
        if (source instanceof Player) {
            Player player = (Player)source;
            if (player.m_21205_().m_150930_((Item)FROSTSTEEL_GREATSWORD.get())) {
                event.getEntity().m_7292_(new MobEffectInstance((MobEffect)UGEffects.CHILLY.get(), 600, 2, false, false));
            }
            if (player.m_21205_().m_150930_((Item)FROSTSTEEL_GREAT_AXE.get())) {
                event.getEntity().m_7292_(new MobEffectInstance((MobEffect)UGEffects.CHILLY.get(), 600, 1, false, false));
            }
        }
    }

    private static void SWutheriumAttackEvent(LivingHurtEvent event) {
        Player player;
        Entity source = event.getSource().m_7639_();
        float damage = event.getAmount();
        if (source instanceof Player && ((player = (Player)source).m_21205_().m_150930_((Item)UTHERIUM_GREATSWORD.get()) || player.m_21205_().m_150930_((Item)UTHERIUM_GREAT_AXE.get())) && event.getEntity().m_6095_().m_204039_(UGTags.Entities.ROTSPAWN)) {
            event.setAmount(damage * 1.5f);
            if (!event.getEntity().m_9236_().m_5776_()) {
                SWUndergardenExtraItems.spawnUtheriumCritParticles((ServerLevel)event.getEntity().m_9236_(), (Entity)event.getEntity());
            }
        }
    }

    private static void spawnUtheriumCritParticles(ServerLevel level, Entity entity) {
        level.m_8767_((ParticleOptions)((SimpleParticleType)UGParticleTypes.UTHERIUM_CRIT.get()), entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() / 2.0, entity.m_20189_(), 10, 0.5, 0.5, 0.5, 0.1);
    }

    public static void register() {
        ExtraCompat.LOGGER.info("Sniff's Weapons/Undergarden compat has been initialized!");
    }
}

