/*
 * Decompiled with CFR 0.152.
 */
package com.ketheroth.uncrafter.common.bock.entity;

import com.ketheroth.uncrafter.Uncrafter;
import com.ketheroth.uncrafter.common.config.UncrafterConfig;
import com.ketheroth.uncrafter.common.inventory.container.AdvancedUncrafterMenu;
import com.ketheroth.uncrafter.common.inventory.container.EnchantmentHandler;
import com.ketheroth.uncrafter.common.inventory.container.InputHandler;
import com.ketheroth.uncrafter.common.inventory.container.ModContainer;
import com.ketheroth.uncrafter.common.inventory.container.OutputHandler;
import com.ketheroth.uncrafter.common.inventory.container.UncrafterMenu;
import com.ketheroth.uncrafter.common.registry.ModBlockEntityTypes;
import com.ketheroth.uncrafter.common.registry.ModBlocks;
import com.ketheroth.uncrafter.common.utils.ExtraDataMenuProvider;
import com.ketheroth.uncrafter.common.utils.PlatformUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class UncrafterBlockEntity
extends BlockEntity
implements ExtraDataMenuProvider {
    public final boolean[] selected;
    private final InputHandler input;
    private final OutputHandler output;
    private final EnchantmentHandler enchantmentOutput;
    private final Tuple<Item, List<ItemStack>> cache = new Tuple(null, null);
    private final boolean isAdvanced;
    private final int maxExtract;
    private int cooldown;

    public UncrafterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.UNCRAFTER.get(), pos, state);
        this.isAdvanced = state.m_60734_() == ModBlocks.ADVANCED_UNCRAFTER_BLOCK.get();
        this.input = new InputHandler(1, this);
        this.output = new OutputHandler(9, this);
        this.enchantmentOutput = this.isAdvanced ? new EnchantmentHandler(6, this) : null;
        this.cooldown = 0;
        this.selected = new boolean[9];
        this.maxExtract = this.isAdvanced ? UncrafterConfig.advancedExtractAmount : UncrafterConfig.extractAmount;
    }

    private static boolean isFullContainer(Container container, Direction direction) {
        return UncrafterBlockEntity.getSlots(container, direction).allMatch(slot -> {
            ItemStack itemstack = container.m_8020_(slot);
            return itemstack.m_41613_() >= itemstack.m_41741_();
        });
    }

    private static boolean isEmptyContainer(Container container, Direction direction) {
        return UncrafterBlockEntity.getSlots(container, direction).allMatch(slot -> container.m_8020_(slot).m_41619_());
    }

    private static IntStream getSlots(Container container, Direction direction) {
        return container instanceof WorldlyContainer ? IntStream.of(((WorldlyContainer)container).m_7071_(direction)) : IntStream.range(0, container.m_6643_());
    }

    private static boolean canTakeItemFromContainer(Container container, ItemStack stack, int slot, Direction direction) {
        return !(container instanceof WorldlyContainer) || ((WorldlyContainer)container).m_7157_(slot, stack, direction);
    }

    private static boolean canMergeItems(ItemStack stack1, ItemStack stack2) {
        if (!stack1.m_150930_(stack2.m_41720_())) {
            return false;
        }
        if (stack1.m_41773_() != stack2.m_41773_()) {
            return false;
        }
        if (stack1.m_41613_() > stack1.m_41741_()) {
            return false;
        }
        return ItemStack.m_41728_((ItemStack)stack1, (ItemStack)stack2);
    }

    public Component m_5446_() {
        if (this.isAdvanced) {
            return Component.m_237115_((String)"screen.uncrafter.advanced_uncrafter_inventory");
        }
        return Component.m_237115_((String)"screen.uncrafter.uncrafter_inventory");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        if (this.isAdvanced) {
            return new AdvancedUncrafterMenu(i, inventory, player, this.f_58858_);
        }
        return new UncrafterMenu(i, inventory, player, this.f_58858_);
    }

    public void tick(Level level, BlockPos pos, BlockState state, UncrafterBlockEntity be) {
        --this.cooldown;
        if (this.cooldown > 0) {
            return;
        }
        this.importItem(level, this.f_58858_.m_7494_(), Direction.DOWN);
        if (!this.input.m_8020_(0).m_41619_()) {
            int i;
            Container container = HopperBlockEntity.m_59390_((Level)level, (BlockPos)this.f_58858_.m_7495_());
            if (container == null || UncrafterBlockEntity.isFullContainer(container, Direction.UP)) {
                return;
            }
            int extracted = 0;
            for (i = 0; i < this.selected.length; ++i) {
                if (!this.selected[i]) continue;
                if (this.extractItem(container, this.output, i)) {
                    ++extracted;
                }
                if (extracted == this.maxExtract) break;
            }
            if (extracted > 0) {
                for (i = 0; i < 9 && extracted < this.maxExtract; ++i) {
                    if (!this.extractItem(container, this.output, i)) continue;
                    ++extracted;
                }
            }
            if (this.isAdvanced) {
                for (i = 0; i < 6 && i < UncrafterConfig.enchantmentExtractAmount; ++i) {
                    this.extractItem(container, this.enchantmentOutput, i);
                }
            }
        }
    }

    private void importItem(Level level, BlockPos position, Direction direction) {
        int[] slots;
        Container container = HopperBlockEntity.m_59390_((Level)level, (BlockPos)position);
        if (container == null || UncrafterBlockEntity.isEmptyContainer(container, direction)) {
            return;
        }
        for (int slot : slots = UncrafterBlockEntity.getSlots(container, direction).toArray()) {
            ItemStack extracting = container.m_8020_(slot);
            if (extracting.m_41619_() || !UncrafterBlockEntity.canTakeItemFromContainer(container, extracting, slot, direction)) continue;
            ItemStack removed = container.m_7407_(slot, 1);
            if (PlatformUtils.isItemNotInTag(removed.m_41720_(), Uncrafter.UNCRAFTER_BLACKLIST)) {
                boolean imported = false;
                if (this.input.m_8020_(0).m_41619_()) {
                    this.input.m_6836_(0, removed);
                    imported = true;
                } else if (UncrafterBlockEntity.canMergeItems(this.input.m_8020_(0), removed)) {
                    ItemStack inputExtracted = this.input.m_7407_(0, 64);
                    int canAdd = removed.m_41741_() - inputExtracted.m_41613_();
                    int willAdd = Math.min(removed.m_41613_(), canAdd);
                    removed.m_41774_(willAdd);
                    inputExtracted.m_41769_(willAdd);
                    this.input.m_6836_(0, inputExtracted);
                    imported = true;
                }
                if (imported) {
                    this.m_6596_();
                    container.m_6596_();
                    this.cooldown = 8;
                    return;
                }
            }
            container.m_6836_(slot, extracting);
        }
    }

    private boolean extractItem(Container container, ModContainer stackHandler, int index) {
        ItemStack copy = stackHandler.m_8020_(index).m_41777_();
        if (!copy.m_41619_()) {
            int[] slots;
            for (int slot : slots = UncrafterBlockEntity.getSlots(container, Direction.UP).toArray()) {
                ItemStack stack = container.m_8020_(slot).m_41777_();
                ItemStack remaining = HopperBlockEntity.m_59326_(null, (Container)container, (ItemStack)copy, (Direction)Direction.UP);
                if (remaining.m_41619_()) {
                    container.m_6596_();
                    this.m_6596_();
                    stackHandler.m_7407_(index, 1);
                    this.cooldown = 8;
                    return true;
                }
                container.m_6836_(slot, stack);
            }
        }
        return false;
    }

    public InputHandler getInput() {
        return this.input;
    }

    public OutputHandler getOutput() {
        return this.output;
    }

    public EnchantmentHandler getEnchantmentOutput() {
        return this.enchantmentOutput;
    }

    public Tuple<Item, List<ItemStack>> getCache() {
        return this.cache;
    }

    public RecipeManager getRecipeManager() {
        return this.f_58857_.m_7465_();
    }

    public boolean isAdvanced() {
        return this.isAdvanced;
    }

    public boolean isInputLocked() {
        return this.output.isExtracting();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag input = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)input, this.input.getItems());
        CompoundTag output = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)output, this.output.getItems());
        tag.m_128365_("input", (Tag)input);
        tag.m_128365_("output", (Tag)output);
        if (this.isAdvanced) {
            CompoundTag enchants = new CompoundTag();
            ContainerHelper.m_18973_((CompoundTag)enchants, this.enchantmentOutput.getItems());
            tag.m_128365_("enchantmentOutput", (Tag)enchants);
        }
        ArrayList<Integer> array = new ArrayList<Integer>();
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            array.add(i);
        }
        tag.m_128408_("selected", array);
    }

    public void m_142466_(CompoundTag tag) {
        int[] selected;
        super.m_142466_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag.m_128469_("input"), this.input.getItems());
        ContainerHelper.m_18980_((CompoundTag)tag.m_128469_("output"), this.output.getItems());
        if (this.isAdvanced) {
            ContainerHelper.m_18980_((CompoundTag)tag.m_128469_("enchantmentOutput"), this.enchantmentOutput.getItems());
        }
        for (int value : selected = tag.m_128465_("selected")) {
            this.selected[value] = true;
        }
    }

    @Override
    public void writeExtraData(ServerPlayer player, FriendlyByteBuf buffer) {
        buffer.m_130064_(this.m_58899_());
    }
}

