/*
 * Decompiled with CFR 0.152.
 */
package com.ketheroth.uncrafter.common.utils.forge;

import com.ketheroth.uncrafter.common.utils.ExtraDataMenuProvider;
import com.ketheroth.uncrafter.common.utils.PlatformUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class PlatformUtilsImpl {
    public static <T extends AbstractContainerMenu> MenuType<T> createMenuType(PlatformUtils.MenuFactory<T> factory) {
        return IForgeMenuType.create(factory::create);
    }

    public static void openMenu(ServerPlayer player, ExtraDataMenuProvider provider) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider, data -> provider.writeExtraData(player, (FriendlyByteBuf)data));
    }

    public static boolean isItemNotInTag(Item item, TagKey<Item> tagKey) {
        return ForgeRegistries.ITEMS.tags().getTag(tagKey).stream().noneMatch(it -> it == item);
    }
}

