/*
 * Decompiled with CFR 0.152.
 */
package com.mysticalchemy.crucible;

import com.mysticalchemy.crucible.BlockEmptyCrucible;
import com.mysticalchemy.crucible.CrucibleTile;
import com.mysticalchemy.crucible.IDontCreateBlockItem;
import com.mysticalchemy.init.BlockInit;
import com.mysticalchemy.init.TileEntityInit;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BlockCrucible
extends LayeredCauldronBlock
implements EntityBlock,
IDontCreateBlockItem {
    public BlockCrucible() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50256_).m_60955_().m_60978_(3.0f), LayeredCauldronBlock.f_153515_, CauldronInteraction.f_175607_);
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CrucibleTile(pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return type == TileEntityInit.CRUCIBLE_TILE_TYPE.get() ? (world1, pos, state1, te) -> CrucibleTile.Tick(world1, pos, state1, (CrucibleTile)te) : null;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        int fillLevel = (Integer)state.m_61143_((Property)f_153514_);
        float insideYPos = (float)pos.m_123342_() + (6.0f + (float)(3 * fillLevel)) / 16.0f;
        if (!worldIn.f_46443_ && fillLevel > 0 && entityIn.m_20186_() <= (double)insideYPos) {
            CrucibleTile crucible;
            if (entityIn instanceof ItemEntity) {
                CrucibleTile crucible2 = (CrucibleTile)worldIn.m_7702_(pos);
                if (crucible2 != null) {
                    ItemStack stack = ((ItemEntity)entityIn).m_32055_();
                    if (crucible2.tryAddIngredient(stack)) {
                        worldIn.m_5594_(null, pos, SoundEvents.f_11917_, SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * (double)0.4f));
                        entityIn.m_142687_(Entity.RemovalReason.KILLED);
                    } else {
                        entityIn.m_5997_(-0.2 + Math.random() * 0.4, 1.0, -0.2 + Math.random() * 0.4);
                    }
                }
            } else if (entityIn instanceof LivingEntity && (crucible = (CrucibleTile)worldIn.m_7702_(pos)) != null && crucible.getHeat() > crucible.getMaxHeat() / 2.0f) {
                entityIn.m_6469_(worldIn.m_269111_().m_269387_(), 1.0f);
            }
        }
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        CrucibleTile crucible;
        if (pLevel.f_46443_ && (Integer)pState.m_61143_((Property)f_153514_) > 0 && (crucible = (CrucibleTile)pLevel.m_7702_(pPos)) != null && crucible.getHeat() >= 100.0f) {
            pLevel.m_5594_(null, pPos, SoundEvents.f_12032_, SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * (double)0.4f));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        HashMap<MobEffect, Float> prominents;
        CrucibleTile crucible = (CrucibleTile)worldIn.m_7702_(pos);
        if (crucible != null && (Integer)state.m_61143_((Property)f_153514_) > 0 && (prominents = crucible.getProminentEffects()).size() > 0) {
            if (player.m_21120_(handIn).m_41720_() == Items.f_42590_) {
                this.extractPotion(worldIn, prominents, crucible, player, handIn, state, pos);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = player.m_21120_(handIn);
        if (itemstack.m_41720_() == Items.f_42447_) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), 3);
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        if (itemstack.m_41720_() == Items.f_42446_) {
            worldIn.m_7731_(pos, ((BlockEmptyCrucible)((Object)BlockInit.EMPTY_CRUCIBLE.get())).m_49966_(), 3);
            player.m_21008_(handIn, new ItemStack((ItemLike)Items.f_42447_));
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return InteractionResult.FAIL;
    }

    private void extractPotion(Level worldIn, HashMap<MobEffect, Float> prominents, CrucibleTile crucible, Player player, InteractionHand handIn, BlockState state, BlockPos pos) {
        if (!worldIn.f_46443_) {
            int existingLevel;
            ArrayList prominentEffects = new ArrayList();
            ItemStack potionstack = this.createBasePotionStack(crucible);
            prominents.forEach((e, f) -> prominentEffects.add(new MobEffectInstance(e, e.m_8093_() ? 1 : crucible.getDuration(), (int)Math.floor(f.floatValue() - 1.0f))));
            PotionUtils.m_43549_((ItemStack)potionstack, (Potion)Potions.f_43599_);
            PotionUtils.m_43552_((ItemStack)potionstack, prominentEffects);
            if (prominentEffects.size() == 1) {
                potionstack.m_41714_((Component)Component.m_237115_((String)((MobEffectInstance)prominentEffects.get(0)).m_19576_()));
            } else {
                potionstack.m_41714_((Component)Component.m_237115_((String)"item.mysticalchemy.concoction"));
            }
            player.m_21120_(handIn).m_41774_(1);
            if (!player.m_36356_(potionstack)) {
                player.m_36176_(potionstack, false);
            }
            if ((existingLevel = ((Integer)state.m_61143_((Property)f_153514_)).intValue()) == 1) {
                worldIn.m_7731_(pos, ((BlockEmptyCrucible)((Object)BlockInit.EMPTY_CRUCIBLE.get())).m_49966_(), 3);
            } else {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)f_153514_, (Comparable)Integer.valueOf(existingLevel - 1)), 3);
            }
        }
    }

    private ItemStack createBasePotionStack(CrucibleTile crucible) {
        Item outputPotionItem = crucible.isLingering() ? Items.f_42739_ : (crucible.isSplash() ? Items.f_42736_ : Items.f_42589_);
        return new ItemStack((ItemLike)outputPotionItem);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }
}

