/*
 * Decompiled with CFR 0.152.
 */
package com.mysticalchemy.crucible;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mysticalchemy.crucible.BlockCrucible;
import com.mysticalchemy.crucible.CrucibleTile;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class CrucibleRenderer
implements BlockEntityRenderer<CrucibleTile> {
    public CrucibleRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(CrucibleTile tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if ((Integer)tileEntityIn.m_58900_().m_61143_((Property)BlockCrucible.f_153514_) > 0) {
            VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110460_((ResourceLocation)new ResourceLocation("textures/block/water_still.png"), (boolean)true));
            long color = tileEntityIn.getPotionColor();
            float[] rgb = this.colorFromLong(color);
            Matrix4f mat = matrixStackIn.m_85850_().m_252922_();
            int frames = 16;
            float frameSize = 1.0f / (float)frames;
            long frame = tileEntityIn.m_58904_().m_46467_() / 3L % (long)frames;
            float min_u = 0.0f;
            float max_u = 1.0f;
            float min_v = frameSize * (float)frame;
            float max_v = frameSize * (float)(frame + 1L);
            float yPos = 0.2f + 0.25f * (float)((Integer)tileEntityIn.m_58900_().m_61143_((Property)BlockCrucible.f_153514_)).intValue();
            CrucibleRenderer.addVertex(builder, mat, 1.0f, yPos, 0.0f, max_u, min_v, rgb, combinedLightIn);
            CrucibleRenderer.addVertex(builder, mat, 0.0f, yPos, 0.0f, min_u, min_v, rgb, combinedLightIn);
            CrucibleRenderer.addVertex(builder, mat, 0.0f, yPos, 1.0f, min_u, max_v, rgb, combinedLightIn);
            CrucibleRenderer.addVertex(builder, mat, 1.0f, yPos, 1.0f, max_u, max_v, rgb, combinedLightIn);
        }
    }

    private float[] colorFromLong(long color) {
        return new float[]{(float)(color >> 16 & 0xFFL) / 255.0f, (float)(color >> 8 & 0xFFL) / 255.0f, (float)(color & 0xFFL) / 255.0f};
    }

    private static void addVertex(VertexConsumer builder, Matrix4f pos, float x, float y, float z, float u, float v, float[] rgb, int combinedLightIn) {
        builder.m_252986_(pos, x, y, z).m_85950_(rgb[0], rgb[1], rgb[2], 1.0f).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(combinedLightIn).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }
}

