/*
 * Decompiled with CFR 0.152.
 */
package com.mysticalchemy.crucible;

import com.mysticalchemy.config.BrewingConfig;
import com.mysticalchemy.crucible.BlockCrucible;
import com.mysticalchemy.crucible.BlockEmptyCrucible;
import com.mysticalchemy.init.BlockInit;
import com.mysticalchemy.init.RecipeInit;
import com.mysticalchemy.init.TileEntityInit;
import com.mysticalchemy.recipe.PotionIngredientRecipe;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class CrucibleTile
extends BlockEntity {
    private static final int UPDATE_RATE = 10;
    public static final float MIN_TEMP = 0.0f;
    public static final float MAX_TEMP = 200.0f;
    public static final float BOIL_POINT = 100.0f;
    public static final float ITEM_HEAT_LOSS = 25.0f;
    public static final int MAX_MAGNITUDE = 3;
    public static final int MAX_EFFECTS = 4;
    public static final int MAX_DURATION = 9600;
    private static HashMap<Block, Float> heaters = new HashMap();
    private float heat = 0.0f;
    private float stir = 0.0f;
    private boolean is_splash = false;
    private boolean is_lingering = false;
    private int duration = 600;
    private HashMap<MobEffect, Float> effectStrengths = new HashMap();
    private RecipeManager recipeManager;
    private Biome myBiome;
    private long targetColor = 12345L;
    private long startColor = 12345L;
    private double infusePct = 1.0;

    public CrucibleTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityInit.CRUCIBLE_TILE_TYPE.get(), pos, state);
    }

    public static void Tick(Level level, BlockPos pos, BlockState state, CrucibleTile blockEntity) {
        blockEntity.tick();
    }

    private void tick() {
        int waterLevel = (Integer)this.m_58900_().m_61143_((Property)BlockCrucible.f_153514_);
        if (this.f_58857_.f_46443_ && waterLevel > 0) {
            this.spawnParticles(waterLevel);
        }
        this.infusePct = Mth.m_14008_((double)(this.infusePct + (double)0.01f), (double)0.0, (double)1.0);
        if (this.f_58857_.m_46467_() % 10L != 0L) {
            return;
        }
        if (this.myBiome == null) {
            this.myBiome = (Biome)this.f_58857_.m_204166_(this.f_58858_).get();
        }
        if (waterLevel == 0) {
            this.resetPotion();
            return;
        }
        if (!this.f_58857_.m_5776_()) {
            this.tickHeatAndStir(waterLevel);
        }
    }

    private void tickHeatAndStir(int waterLevel) {
        Block below = this.f_58857_.m_8055_(this.m_58899_().m_7495_()).m_60734_();
        float preHeat = this.heat;
        this.heat = heaters.containsKey(below) ? Mth.m_14036_((float)(this.heat + heaters.get(below).floatValue()), (float)0.0f, (float)200.0f) : Mth.m_14036_((float)(this.heat - (1.0f - this.myBiome.m_47554_()) * 10.0f), (float)0.0f, (float)200.0f);
        this.stir = this.stir > 0.25f ? Mth.m_14036_((float)(this.stir - 0.02f), (float)0.0f, (float)1.0f) : Mth.m_14036_((float)(this.stir - 0.005f), (float)0.0f, (float)1.0f);
        if (this.heat >= 100.0f && this.stir == 0.0f && Math.random() < (double)0.1f) {
            if (waterLevel == 1) {
                this.f_58857_.m_46597_(this.m_58899_(), ((BlockEmptyCrucible)((Object)BlockInit.EMPTY_CRUCIBLE.get())).m_49966_());
            } else {
                this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockCrucible.f_153514_, (Comparable)Integer.valueOf(waterLevel - 1)));
            }
        }
        if (this.heat != preHeat) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private void resetPotion() {
        this.heat = 0.0f;
        this.stir = 1.0f;
        this.is_splash = false;
        this.is_lingering = false;
        this.duration = 600;
        this.effectStrengths.clear();
        this.infusePct = 1.0;
        this.targetColor = 12345L;
    }

    private void spawnParticles(int waterLevel) {
        if (this.getHeat() > 100.0f) {
            int numBubbles = (int)Math.ceil(5.0f * ((this.getHeat() - 100.0f) / (this.getMaxHeat() - 100.0f)));
            for (int i = 0; i < numBubbles; ++i) {
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123772_, (double)this.m_58899_().m_123341_() + 0.5 - 0.3 + Math.random() * 0.6, (double)this.m_58899_().m_123342_() + 0.2 + (double)(0.25f * (float)waterLevel), (double)this.m_58899_().m_123343_() + 0.5 - 0.3 + Math.random() * 0.6, 0.0, this.is_splash ? 0.125 : 0.0, 0.0);
            }
            if (this.stir < 0.25f) {
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)this.m_58899_().m_123341_() + 0.5 - 0.3 + Math.random() * 0.6, (double)this.m_58899_().m_123342_() + 0.2 + (double)(0.25f * (float)waterLevel), (double)this.m_58899_().m_123343_() + 0.5 - 0.3 + Math.random() * 0.6, 0.0, (double)0.01f + (0.25 - (double)this.stir) * 0.25, 0.0);
            }
        }
    }

    public boolean tryAddIngredient(ItemStack stack) {
        if (this.infusePct != 1.0 || this.heat < 100.0f) {
            return false;
        }
        if (this.recipeManager == null) {
            this.recipeManager = this.f_58857_.m_7465_();
        }
        if (this.recipeManager == null) {
            return false;
        }
        Optional recipe = this.recipeManager.m_44056_((RecipeType)RecipeInit.POTION_RECIPE_TYPE.get(), (Container)this.createDummyCraftingInventory(stack), this.f_58857_).stream().findFirst();
        if (recipe.isPresent() && this.canMerge((PotionIngredientRecipe)((Object)recipe.get()), stack.m_41613_())) {
            PotionIngredientRecipe resolved_recipe = (PotionIngredientRecipe)((Object)recipe.get());
            if (resolved_recipe.getMakesLingering()) {
                this.is_lingering = true;
            }
            if (resolved_recipe.getMakesSplash()) {
                this.is_splash = true;
            }
            if (resolved_recipe.getDurationAdded() > 0) {
                this.duration += resolved_recipe.getDurationAdded() * stack.m_41613_();
            }
            this.heat = Mth.m_14036_((float)(this.heat - 25.0f * (float)stack.m_41613_()), (float)0.0f, (float)200.0f);
            this.mergeEffects(resolved_recipe.getEffects(), stack.m_41613_());
            this.recalculatePotionColor();
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            return true;
        }
        return false;
    }

    private void recalculatePotionColor() {
        HashMap<MobEffect, Float> prominents = this.getProminentEffects();
        if (prominents.size() == 0) {
            this.targetColor = 12345L;
            this.infusePct = 1.0;
            return;
        }
        long color = 0L;
        for (MobEffect e : prominents.keySet()) {
            color += (long)e.m_19484_();
        }
        if (this.targetColor != (color /= (long)prominents.size())) {
            this.startColor = this.getPotionColor();
            this.targetColor = color;
            this.infusePct = 0.0;
        }
    }

    private boolean canMerge(PotionIngredientRecipe recipe, int quantity) {
        HashMap<MobEffect, Float> prominent = this.getProminentEffects();
        for (MobEffect e : recipe.getEffects().keySet()) {
            if (e == null) continue;
            if (prominent.size() >= 4) {
                float newMagnitude = this.effectStrengths.containsKey(e) ? this.effectStrengths.get(e).floatValue() : 0.0f;
                newMagnitude += recipe.getEffects().get(e).floatValue() * (float)quantity;
                if (!prominent.containsKey(e) && newMagnitude >= 1.0f) {
                    return false;
                }
            }
            if (this.effectStrengths.containsKey(e) && this.effectStrengths.get(e).floatValue() + recipe.getEffects().get(e).floatValue() * (float)quantity > 3.0f) {
                return false;
            }
            if (!(recipe.getEffects().get(e).floatValue() * (float)quantity > 3.0f)) continue;
            return false;
        }
        return recipe.getDurationAdded() * quantity + this.duration <= 9600;
    }

    private void mergeEffects(HashMap<MobEffect, Float> effectList, int quantity) {
        effectList.forEach((e, f) -> {
            if (e != null) {
                ResourceLocation key = ForgeRegistries.MOB_EFFECTS.getKey(e);
                if (key != null && BrewingConfig.isEffectDisabled(key)) {
                    return;
                }
                if (this.effectStrengths.containsKey(e)) {
                    this.effectStrengths.put((MobEffect)e, Float.valueOf(Math.min(this.effectStrengths.get(e).floatValue() + f.floatValue() * (float)quantity, 3.0f)));
                } else {
                    this.effectStrengths.put((MobEffect)e, Float.valueOf(Math.min(f.floatValue() * (float)quantity, 3.0f)));
                }
            }
        });
    }

    private CraftingContainer createDummyCraftingInventory(ItemStack stack) {
        TransientCraftingContainer craftinginventory = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

            public boolean m_6875_(Player playerIn) {
                return false;
            }

            public ItemStack m_7648_(Player pPlayer, int pIndex) {
                return ItemStack.f_41583_;
            }
        }, 1, 1);
        craftinginventory.m_6836_(0, stack);
        return craftinginventory;
    }

    public HashMap<MobEffect, Float> getProminentEffects() {
        HashMap<MobEffect, Float> effects = new HashMap<MobEffect, Float>();
        this.effectStrengths.forEach((e, f) -> {
            if (f.floatValue() >= 1.0f && !BrewingConfig.isEffectDisabled(ForgeRegistries.MOB_EFFECTS.getKey(e))) {
                effects.put((MobEffect)e, (Float)f);
            }
        });
        return effects;
    }

    public HashMap<MobEffect, Float> getAllEffects() {
        return (HashMap)this.effectStrengths.clone();
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128350_("heat", this.heat);
        compound.m_128350_("stir", this.stir);
        compound.m_128379_("splash", this.is_splash);
        compound.m_128379_("lingering", this.is_lingering);
        compound.m_128405_("duration", this.duration);
        compound.m_128405_("numEffects", this.effectStrengths.size());
        int count = 0;
        for (MobEffect e : this.effectStrengths.keySet()) {
            compound.m_128359_("effect" + count, ForgeRegistries.MOB_EFFECTS.getKey((Object)e).toString());
            compound.m_128350_("effectstr" + count, this.effectStrengths.get(e).floatValue());
            ++count;
        }
    }

    public void m_142466_(CompoundTag data) {
        super.m_142466_(data);
        if (data.m_128441_("heat")) {
            this.heat = data.m_128457_("heat");
        }
        if (data.m_128441_("stir")) {
            this.stir = data.m_128457_("stir");
        }
        if (data.m_128441_("splash")) {
            this.is_splash = data.m_128471_("splash");
        }
        if (data.m_128441_("lingering")) {
            this.is_lingering = data.m_128471_("lingering");
        }
        if (data.m_128441_("duration")) {
            this.duration = data.m_128451_("duration");
        }
        if (data.m_128441_("numEffects")) {
            int count = data.m_128451_("numEffects");
            for (int i = 0; i < count; ++i) {
                MobEffect e;
                if (!data.m_128441_("effect" + i) || !data.m_128441_("effectstr" + i) || (e = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(data.m_128461_("effect" + i)))) == null) continue;
                this.effectStrengths.put(e, Float.valueOf(data.m_128457_("effectstr" + i)));
            }
        }
        this.recalculatePotionColor();
    }

    public float getHeat() {
        return this.heat;
    }

    public float getMaxHeat() {
        return 200.0f;
    }

    public void stir() {
        this.stir = 1.0f;
    }

    public float getStir() {
        return this.stir;
    }

    public boolean isSplash() {
        return this.is_splash;
    }

    public void setSplash(boolean splash) {
        this.is_splash = splash;
    }

    public boolean isLingering() {
        return this.is_lingering;
    }

    public void setLingering(boolean lingering) {
        this.is_lingering = lingering;
    }

    public int getDuration() {
        return this.duration;
    }

    public void addDuration(int duration) {
        this.duration += duration;
    }

    public boolean isPotion() {
        for (MobEffect e : this.effectStrengths.keySet()) {
            if (!(this.effectStrengths.get(e).floatValue() >= 1.0f)) continue;
            return true;
        }
        return false;
    }

    public long getPotionColor() {
        if (this.infusePct == 1.0) {
            return this.targetColor;
        }
        int[] rgb_start = new int[]{(int)(this.startColor >> 16 & 0xFFL), (int)(this.startColor >> 8 & 0xFFL), (int)(this.startColor & 0xFFL)};
        int[] rgb_target = new int[]{(int)(this.targetColor >> 16 & 0xFFL), (int)(this.targetColor >> 8 & 0xFFL), (int)(this.targetColor & 0xFFL)};
        int[] lerp_color = new int[3];
        for (int i = 0; i < 3; ++i) {
            lerp_color[i] = rgb_start[i] + (int)((double)(rgb_target[i] - rgb_start[i]) * this.infusePct);
        }
        long outputColor = 0L;
        outputColor += (long)(lerp_color[0] << 16);
        outputColor += (long)(lerp_color[1] << 8);
        return outputColor += (long)lerp_color[2];
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    static {
        heaters.put(Blocks.f_50683_, Float.valueOf(1.0f));
        heaters.put(Blocks.f_50083_, Float.valueOf(2.0f));
        heaters.put(Blocks.f_49991_, Float.valueOf(5.0f));
        heaters.put(Blocks.f_50126_, Float.valueOf(-2.0f));
    }
}

