/*
 * Decompiled with CFR 0.152.
 */
package com.mysticalchemy.crucible;

import com.mysticalchemy.crucible.CrucibleTile;
import com.mysticalchemy.init.BlockInit;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;

public class ItemSamplingKit
extends Item {
    private float threshold;

    public ItemSamplingKit(float threshold) {
        super(new Item.Properties());
        this.threshold = threshold;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        if (state.m_60734_() == BlockInit.CRUCIBLE.get() && !context.m_43725_().f_46443_) {
            HashMap<MobEffect, Float> allEffects;
            CrucibleTile crucible = (CrucibleTile)context.m_43725_().m_7702_(context.m_8083_());
            if (crucible == null) {
                return InteractionResult.FAIL;
            }
            if (!context.m_43723_().m_7500_()) {
                stack.m_41774_(1);
            }
            if ((allEffects = crucible.getAllEffects()).size() == 0) {
                context.m_43723_().m_213846_((Component)Component.m_237115_((String)"chat.mysticalchemy.no_effects"));
                return InteractionResult.SUCCESS;
            }
            if (allEffects.values().stream().noneMatch(f -> f.floatValue() >= this.threshold)) {
                context.m_43723_().m_213846_((Component)Component.m_237115_((String)"chat.mysticalchemy.no_notable_effects"));
                return InteractionResult.SUCCESS;
            }
            allEffects.forEach((e, f) -> {
                if (f.floatValue() >= this.threshold) {
                    MutableComponent ttc = Component.m_237110_((String)"chat.mysticalchemy.format_effect", (Object[])new Object[]{String.format("%.2f", f), e.m_19482_().getString()}).m_130940_(f.floatValue() >= 1.0f ? ChatFormatting.GREEN : ChatFormatting.DARK_RED);
                    context.m_43723_().m_213846_((Component)ttc);
                }
            });
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

