/*
 * Decompiled with CFR 0.152.
 */
package einstein.usefulslime.util;

import einstein.usefulslime.platform.Services;
import java.util.IdentityHashMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class BounceHandler {
    public static final IdentityHashMap<Entity, BounceHandler> BOUNCING_ENTITIES = new IdentityHashMap();
    public final LivingEntity entity;
    private int timer;
    private boolean wasInAir;
    private double bounce;
    private int bounceTick;
    private double lastMoveX;
    private double lastMoveZ;

    public BounceHandler(LivingEntity entity, double bounce) {
        this.entity = entity;
        this.timer = 0;
        this.wasInAir = false;
        this.bounce = bounce;
        this.bounceTick = bounce != 0.0 ? entity.f_19797_ : 0;
        BOUNCING_ENTITIES.put((Entity)entity, this);
    }

    public void onPlayerTick(Player player) {
        if (player == this.entity && !player.m_21255_()) {
            if (player.f_19797_ == this.bounceTick) {
                Vec3 playerMovement = player.m_20184_();
                player.m_20334_(playerMovement.f_82479_, this.bounce, playerMovement.f_82481_);
                this.bounceTick = 0;
            }
            if (!(this.entity.m_20096_() || this.entity.f_19797_ == this.bounceTick || this.lastMoveX == this.entity.m_20184_().f_82479_ && this.lastMoveZ == this.entity.m_20184_().f_82481_)) {
                double d = 0.935;
                Vec3 entityMovement = this.entity.m_20184_();
                player.m_20334_(entityMovement.f_82479_ / d, entityMovement.f_82480_, entityMovement.f_82481_ / d);
                this.entity.f_19812_ = true;
                this.lastMoveX = this.entity.m_20184_().f_82479_;
                this.lastMoveZ = this.entity.m_20184_().f_82481_;
            }
            if (this.wasInAir && this.entity.m_20096_()) {
                if (this.timer == 0) {
                    this.timer = this.entity.f_19797_;
                } else if (this.entity.f_19797_ - this.timer > 5) {
                    BOUNCING_ENTITIES.remove(this.entity);
                }
            } else {
                this.timer = 0;
                this.wasInAir = true;
            }
        }
    }

    public static void addBounceHandler(LivingEntity entity) {
        BounceHandler.addBounceHandler(entity, 0.0);
    }

    public static void addBounceHandler(LivingEntity entity, double bounce) {
        if (!(entity instanceof Player) || Services.PLATFORM.isFakePlayer(entity)) {
            return;
        }
        BounceHandler handler = BOUNCING_ENTITIES.get(entity);
        if (handler == null) {
            new BounceHandler(entity, bounce);
        } else if (bounce != 0.0) {
            handler.bounce = bounce;
            handler.bounceTick = entity.f_19797_;
        }
    }
}

