/*
 * Decompiled with CFR 0.152.
 */
package mezz.itemzoom.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mezz.itemzoom.client.KeyBindings;
import mezz.itemzoom.client.compat.JeiCompat;
import mezz.itemzoom.client.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

@OnlyIn(value=Dist.CLIENT)
public class RenderHandler {
    @Nullable
    public static Rect2i rendering = null;
    @Nullable
    private static Rect2i renderedThisFrame = null;
    private final Config config;
    private final Supplier<Boolean> isEnableKeyHeld;

    public RenderHandler(Config config, Supplier<Boolean> isEnableKeyHeld) {
        this.config = config;
        this.isEnableKeyHeld = isEnableKeyHeld;
    }

    public void onScreenDrawn() {
        rendering = renderedThisFrame;
        renderedThisFrame = null;
    }

    public void onItemStackTooltip(GuiGraphics guiGraphics, @Nullable ItemStack itemStack, int x, int y) {
        AbstractContainerScreen containerScreen;
        Rect2i renderArea;
        if (!this.config.isToggledEnabled() && !this.isEnableKeyHeld.get().booleanValue()) {
            return;
        }
        if (itemStack == null || itemStack.m_41619_()) {
            return;
        }
        if (this.config.isJeiOnly() && !ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)JeiCompat.getStackUnderMouse())) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Screen currentScreen = minecraft.f_91080_;
        if (currentScreen instanceof AbstractContainerScreen && !(renderArea = this.getRenderingArea(containerScreen = (AbstractContainerScreen)currentScreen, x)).m_110087_(x, y) && this.renderZoomedStack(guiGraphics, itemStack, renderArea, minecraft)) {
            renderedThisFrame = renderArea;
        }
    }

    public Rect2i getRenderingArea(AbstractContainerScreen<?> containerScreen, int mouseX) {
        Minecraft minecraft = containerScreen.getMinecraft();
        Window window = minecraft.m_91268_();
        int guiRight = containerScreen.getGuiLeft() + containerScreen.getXSize();
        int spaceOnLeft = this.getSpaceOnLeft(containerScreen);
        int spaceOnRight = window.m_85445_() - guiRight;
        boolean renderLeft = mouseX < containerScreen.getGuiLeft() ? false : (mouseX > guiRight ? true : (double)spaceOnLeft * 1.1 >= (double)spaceOnRight);
        int y = containerScreen.getGuiTop();
        int height = containerScreen.getYSize();
        if (renderLeft) {
            return new Rect2i(0, y, spaceOnLeft, height);
        }
        return new Rect2i(guiRight, y, spaceOnRight, height);
    }

    private int getSpaceOnLeft(AbstractContainerScreen<?> containerScreen) {
        RecipeUpdateListener recipeListener;
        RecipeBookComponent guiRecipeBook;
        if (containerScreen instanceof RecipeUpdateListener && (guiRecipeBook = (recipeListener = (RecipeUpdateListener)containerScreen).m_5564_()).m_100385_()) {
            return guiRecipeBook.f_100279_.stream().findAny().map(AbstractWidget::m_252754_).orElse((guiRecipeBook.f_100277_ - 147) / 2 - guiRecipeBook.f_100276_);
        }
        return containerScreen.getGuiLeft();
    }

    private boolean renderZoomedStack(GuiGraphics guiGraphics, ItemStack itemStack, Rect2i availableArea, Minecraft minecraft) {
        int availableAreaX = availableArea.m_110085_();
        int availableAreaY = availableArea.m_110086_();
        int availableAreaWidth = availableArea.m_110090_();
        int availableAreaHeight = availableArea.m_110091_();
        float scale = (float)this.config.getZoomAmount() / 100.0f * (float)availableAreaWidth / 17.0f;
        if (scale <= 2.0f) {
            return false;
        }
        float renderWidth = scale * 16.0f;
        float renderHeight = scale * 16.0f;
        float xPosition = (float)availableAreaX + ((float)availableAreaWidth - renderWidth) / 2.0f;
        float yPosition = (float)availableAreaY + ((float)availableAreaHeight - renderHeight) / 2.0f;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(xPosition, yPosition, 0.0f);
        poseStack.m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280480_(itemStack, 0, 0);
        RenderSystem.setShader(GameRenderer::m_172811_);
        this.renderItemOverlayIntoGUI(guiGraphics, itemStack);
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        if (this.config.showHelpText()) {
            int y = availableAreaY + (availableAreaHeight + Math.round(19.0f * scale)) / 2;
            String modName = "Item Zoom";
            Font nameFont = RenderHandler.getFont(minecraft, itemStack, IClientItemExtensions.FontContext.SELECTED_ITEM_NAME);
            int stringWidth = nameFont.m_92895_(modName);
            if (stringWidth < availableAreaWidth) {
                int x = availableAreaX + (availableAreaWidth - stringWidth) / 2;
                guiGraphics.m_280056_(nameFont, modName, x, y, 0x404040, false);
                Objects.requireNonNull(nameFont);
                y += 9;
            }
            if (this.config.isToggledEnabled()) {
                KeyBindings keyBindings = KeyBindings.getInstance();
                Font minecraftFont = minecraft.f_91062_;
                Component displayName = keyBindings.toggle.m_90863_();
                String toggleText = displayName.getString();
                stringWidth = minecraftFont.m_92895_(toggleText);
                if (stringWidth < availableAreaWidth) {
                    int x = availableAreaX + (availableAreaWidth - stringWidth) / 2;
                    guiGraphics.m_280056_(minecraftFont, toggleText, x, y, 0x404040, false);
                }
            }
        }
        return true;
    }

    private static Font getFont(Minecraft minecraft, ItemStack itemStack, IClientItemExtensions.FontContext context) {
        IClientItemExtensions renderProperties = IClientItemExtensions.of((ItemStack)itemStack);
        Font fontRenderer = renderProperties.getFont(itemStack, context);
        if (fontRenderer == null) {
            fontRenderer = minecraft.f_91062_;
        }
        return fontRenderer;
    }

    public void renderItemOverlayIntoGUI(GuiGraphics guiGraphics, ItemStack itemStack) {
        ItemCooldowns cooldowns;
        float cooldownPercent;
        LocalPlayer localplayer;
        if (itemStack.m_41619_()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        if (this.config.showStackSize() && itemStack.m_41613_() != 1) {
            String countString = String.valueOf(itemStack.m_41613_());
            Font itemCountFont = RenderHandler.getFont(minecraft, itemStack, IClientItemExtensions.FontContext.ITEM_COUNT);
            poseStack.m_252880_(0.0f, 0.0f, 200.0f);
            Tesselator tesselator = Tesselator.m_85913_();
            MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)tesselator.m_85915_());
            itemCountFont.m_271703_(countString, 17.0f - (float)itemCountFont.m_92895_(countString), 9.0f, 0xFFFFFF, true, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            bufferSource.m_109911_();
        }
        if (this.config.showDurabilityBar() && itemStack.m_150947_()) {
            RenderSystem.disableDepthTest();
            int k = itemStack.m_150948_();
            int l = itemStack.m_150949_();
            guiGraphics.m_280509_(2, 13, 15, 15, -16777215);
            guiGraphics.m_280509_(2, 13, 2 + k, 14, l | 0xFF000001);
            RenderSystem.enableDepthTest();
        }
        if (this.config.showCooldown() && (localplayer = minecraft.f_91074_) != null && (cooldownPercent = (cooldowns = localplayer.m_36335_()).m_41521_(itemStack.m_41720_(), minecraft.m_91296_())) > 0.0f) {
            RenderSystem.disableDepthTest();
            int i1 = Mth.m_14143_((float)(16.0f * (1.0f - cooldownPercent)));
            int j1 = i1 + Mth.m_14167_((float)(16.0f * cooldownPercent));
            guiGraphics.m_280509_(0, i1, 16, j1, Integer.MAX_VALUE);
            RenderSystem.enableDepthTest();
        }
        poseStack.m_85849_();
    }
}

