/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.CrashUtilCommands.InventoryCommands;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.WorldUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class RemoveFromInventorySlotCommand {
    private static final List<String> invTypes = new ArrayList<String>(Arrays.asList("inventory", "armor", "offhand"));
    private static SuggestionProvider<CommandSourceStack> invtype;

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        if (CrashUtils.curiosLoaded && CuriosApi.getSlotHelper() != null) {
            invTypes.addAll(CuriosApi.getSlotHelper().getSlotTypeIds());
        }
        invtype = (ctx, builder) -> SharedSuggestionProvider.m_82981_(invTypes.stream(), (SuggestionsBuilder)builder);
        return Commands.m_82127_((String)"remove").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).suggests(CommandUtils.PROFILEPROVIDER).then(Commands.m_82129_((String)"slotType", (ArgumentType)StringArgumentType.string()).suggests(invtype).then(Commands.m_82129_((String)"slot", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> RemoveFromInventorySlotCommand.removeFromSlot((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"slotType"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"slot")))))).then(Commands.m_82129_((String)"slot", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> RemoveFromInventorySlotCommand.removeFromSlot((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name"), "inventory", IntegerArgumentType.getInteger((CommandContext)ctx, (String)"slot")))));
    }

    private static int removeFromSlot(CommandContext<CommandSourceStack> context, String name, String inventoryType, int slot) {
        AtomicReference<MutableComponent> text = new AtomicReference<MutableComponent>(CommandUtils.CreateTextComponent(""));
        AtomicBoolean success = new AtomicBoolean(false);
        WorldUtils.applyToPlayer(name, ((CommandSourceStack)context.getSource()).m_81377_(), player -> {
            switch (inventoryType) {
                case "inventory": {
                    if (((ItemStack)player.m_150109_().f_35974_.get(slot)).m_41619_()) {
                        success.set(false);
                        return;
                    }
                    text.set(((ItemStack)player.m_150109_().f_35974_.get(slot)).m_41611_().m_6881_());
                    player.m_150109_().f_35974_.set(slot, (Object)ItemStack.f_41583_);
                    break;
                }
                case "armor": {
                    if (((ItemStack)player.m_150109_().f_35975_.get(slot)).m_41619_()) {
                        success.set(false);
                        return;
                    }
                    text.set(((ItemStack)player.m_150109_().f_35975_.get(slot)).m_41611_().m_6881_());
                    player.m_150109_().f_35975_.set(slot, (Object)ItemStack.f_41583_);
                    break;
                }
                case "offhand": {
                    if (((ItemStack)player.m_150109_().f_35976_.get(slot)).m_41619_()) {
                        success.set(false);
                        return;
                    }
                    text.set(((ItemStack)player.m_150109_().f_35976_.get(slot)).m_41611_().m_6881_());
                    player.m_150109_().f_35976_.set(slot, (Object)ItemStack.f_41583_);
                    break;
                }
                default: {
                    if (!CrashUtils.curiosLoaded || !CuriosApi.getSlotHelper().getSlotTypeIds().contains(inventoryType)) break;
                    ICuriosItemHandler handler = (ICuriosItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).orElse(null);
                    if (((ICurioStacksHandler)handler.getStacksHandler(inventoryType).get()).getStacks().getStackInSlot(slot).m_41619_()) {
                        success.set(false);
                        return;
                    }
                    text.set(((ICurioStacksHandler)handler.getStacksHandler(inventoryType).get()).getStacks().getStackInSlot(slot).m_41611_().m_6881_());
                    ((ICurioStacksHandler)handler.getStacksHandler(inventoryType).get()).getStacks().setStackInSlot(slot, ItemStack.f_41583_);
                }
            }
            success.set(true);
        });
        if (success.get()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> ((MutableComponent)text.get()).m_7220_((Component)CommandUtils.CreateTextComponent(" has been deleted from " + name + "'s InventorySlot")), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> CommandUtils.CreateTextComponent("Failed to delete item from slot" + slot + ", slot is empty?"), true);
        }
        return 1;
    }
}

