/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.ClientEvents;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class OpenPlayerInvMessage {
    Map<String, Integer> slotAmounts;
    String otherPlayerName;
    int windowID;

    public OpenPlayerInvMessage(int id, String playerName, Map<String, Integer> curios) {
        this.windowID = id;
        this.otherPlayerName = playerName;
        this.slotAmounts = curios;
    }

    public static void encode(OpenPlayerInvMessage data, FriendlyByteBuf buf) {
        buf.writeInt(data.windowID);
        buf.m_130070_(data.otherPlayerName);
        buf.writeInt(data.slotAmounts.size());
        data.slotAmounts.forEach((s, i) -> {
            buf.m_130070_(s);
            buf.writeInt(i.intValue());
        });
    }

    public static OpenPlayerInvMessage decode(FriendlyByteBuf buf) {
        LinkedHashMap<String, Integer> curios = new LinkedHashMap<String, Integer>();
        int id = buf.readInt();
        String name = buf.m_130277_();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            curios.put(buf.m_130277_(), buf.readInt());
        }
        return new OpenPlayerInvMessage(id, name, curios);
    }

    public static boolean handle(OpenPlayerInvMessage data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientEvents.openContainerAndScreen(data.windowID, data.otherPlayerName, data.slotAmounts));
        return true;
    }
}

