/*
 * Decompiled with CFR 0.152.
 */
package com.craisinlord.integrated_villages.lootmanager;

import com.craisinlord.integrated_api.utils.PlatformHooks;
import com.craisinlord.integrated_villages.IntegratedVillages;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.loot.LootTable;

public class StructureModdedLootImporter {
    public static final Map<ResourceLocation, ResourceLocation> TABLE_IMPORTS = StructureModdedLootImporter.createMap();

    public static Map<ResourceLocation, ResourceLocation> createMap() {
        HashMap<ResourceLocation, ResourceLocation> tableMap = new HashMap<ResourceLocation, ResourceLocation>();
        tableMap.put(new ResourceLocation("integrated_villages", "chests/tavern_village/tavern_village"), new ResourceLocation("minecraft:chests/village/village_taiga_house"));
        tableMap.put(new ResourceLocation("integrated_villages", "chests/tavern_village/tavern_village_blacksmith"), new ResourceLocation("minecraft:chests/village/village_weaponsmith"));
        if (PlatformHooks.isModLoaded((String)"betterstrongholds")) {
            tableMap.put(new ResourceLocation("betterstrongholds", "chests/end/armoury"), new ResourceLocation("minecraft:chests/end_city_treasure"));
            tableMap.put(new ResourceLocation("betterstrongholds", "chests/end/common"), new ResourceLocation("minecraft:chests/end_city_treasure"));
        }
        return tableMap;
    }

    public static void checkLoottables(MinecraftServer minecraftServer) {
        boolean invalidLootTableFound = false;
        for (Map.Entry<ResourceLocation, ResourceLocation> entry : TABLE_IMPORTS.entrySet()) {
            if (entry.getKey().m_135827_().equals("betterstrongholds") || !StructureModdedLootImporter.isInvalidLootTableFound(minecraftServer, entry)) continue;
            invalidLootTableFound = true;
        }
        if (invalidLootTableFound) {
            IntegratedVillages.LOGGER.error("Unknown import/target loot tables found for Integrated Villages. See above logs and report to CraisinLord.");
        }
    }

    public static boolean isInvalidLootTableFound(MinecraftServer minecraftServer, Map.Entry<ResourceLocation, ResourceLocation> entry) {
        boolean invalidLootTableFound = false;
        if (minecraftServer.m_278653_().m_278676_(entry.getKey()) == LootTable.f_79105_) {
            IntegratedVillages.LOGGER.error("Unable to find loot table key: {}", (Object)entry.getKey());
            invalidLootTableFound = true;
        }
        if (minecraftServer.m_278653_().m_278676_(entry.getValue()) == LootTable.f_79105_) {
            IntegratedVillages.LOGGER.error("Unable to find loot table value: {}", (Object)entry.getValue());
            invalidLootTableFound = true;
        }
        return invalidLootTableFound;
    }
}

