/*
 * Decompiled with CFR 0.152.
 */
package com.teampotato.despawn_tweaker.mixin;

import com.teampotato.despawn_tweaker.DespawnTweaker;
import com.teampotato.despawn_tweaker.api.IMob;
import java.util.Collections;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Mob.class})
public abstract class MobMixin
extends LivingEntity
implements IMob {
    @Shadow
    private boolean f_21353_;
    @Unique
    private static final EquipmentSlot[] EQUIPMENT_SLOTS = EquipmentSlot.values();
    @Unique
    @Nullable
    private Set<Structure> despawnTweaker$spawnStructures = null;

    @Shadow
    @NotNull
    public abstract ItemStack m_6844_(@NotNull EquipmentSlot var1);

    protected MobMixin(EntityType<? extends LivingEntity> arg, Level arg2) {
        super(arg, arg2);
    }

    @Inject(method={"setItemSlotAndDropWhenKilled"}, at={@At(value="TAIL")})
    private void onSetItemSlotAndDropWhenKilled(EquipmentSlot arg, ItemStack itemStack, CallbackInfo ci) {
        if (((Boolean)DespawnTweaker.ENABLE_LET_ME_DESPAWN_OPTIMIZATION.get()).booleanValue()) {
            EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)itemStack);
            ItemStack stack = this.m_6844_(equipmentSlot);
            stack.m_41784_().m_128379_("DespawnTweakerPicked", true);
            this.m_20049_("despawnTweaker.pickedItems");
            this.f_21353_ = this.m_8077_();
        }
    }

    @Inject(method={"checkDespawn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Mob;discard()V", shift=At.Shift.AFTER)})
    private void onDespawn(CallbackInfo ci) {
        if (((Boolean)DespawnTweaker.ENABLE_LET_ME_DESPAWN_OPTIMIZATION.get()).booleanValue() && this.m_19880_().contains("despawnTweaker.pickedItems")) {
            this.despawnTweaker$dropEquipmentOnDespawn();
        }
    }

    @Unique
    private void despawnTweaker$dropEquipmentOnDespawn() {
        if (!((Boolean)DespawnTweaker.ALLOW_EQUIPMENT_DROPS.get()).booleanValue()) {
            return;
        }
        for (EquipmentSlot equipmentSlot : EQUIPMENT_SLOTS) {
            boolean tagPresent;
            ItemStack itemStack = this.m_6844_(equipmentSlot);
            CompoundTag tag = itemStack.m_41783_();
            boolean bl = tagPresent = tag != null;
            if (itemStack.m_41619_() || tagPresent && tag.toString().contains("vanishing_curse")) continue;
            if (tagPresent && tag.m_128471_("DespawnTweakerPicked")) {
                itemStack.m_41749_("Picked");
            }
            this.m_19983_(itemStack);
            this.m_8061_(equipmentSlot, ItemStack.f_41583_);
        }
    }

    @Unique
    private void despawnTweaker$removeTagOnDeath() {
        for (EquipmentSlot equipmentSlot : EQUIPMENT_SLOTS) {
            boolean tagPresent;
            ItemStack itemStack = this.m_6844_(equipmentSlot);
            CompoundTag tag = itemStack.m_41783_();
            boolean bl = tagPresent = tag != null;
            if (!tagPresent || itemStack.m_41619_() || tag.toString().contains("vanishing_curse") || !tag.m_128471_("DespawnTweakerPicked")) continue;
            itemStack.m_41749_("DespawnTweakerPicked");
        }
    }

    @Inject(method={"dropFromLootTable", "dropCustomDeathLoot"}, at={@At(value="HEAD")})
    private void onDropFromLootTable(CallbackInfo ci) {
        if (this.m_19880_().contains("despawnTweaker.pickedItems")) {
            this.despawnTweaker$removeTagOnDeath();
        }
    }

    @Override
    @NotNull
    public Set<Structure> despawnTweaker$getSpawnStructures() {
        return this.despawnTweaker$spawnStructures == null ? Collections.emptySet() : this.despawnTweaker$spawnStructures;
    }

    @Override
    public void despawnTweaker$setSpawnStructures(Set<Structure> structureFeature) {
        this.despawnTweaker$spawnStructures = structureFeature;
    }
}

