/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.personality.core;

import com.teamabnormals.blueprint.common.world.storage.tracking.DataProcessors;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataProcessor;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedData;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedDataManager;
import com.teamabnormals.personality.client.PersonalityClient;
import com.teamabnormals.personality.common.network.MessageC2SCrawl;
import com.teamabnormals.personality.common.network.MessageC2SSit;
import com.teamabnormals.personality.common.network.MessageS2CSyncCrawl;
import com.teamabnormals.personality.common.network.MessageS2CSyncSit;
import com.teamabnormals.personality.core.PersonalityConfig;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod(value="personality")
public class Personality {
    public static final String MOD_ID = "personality";
    public static final String NETWORK_PROTOCOL = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("personality", "net")).networkProtocolVersion(() -> "1").clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).simpleChannel();
    public static final TrackedData<Byte> CLIMBING = TrackedData.Builder.create((IDataProcessor)DataProcessors.BYTE, () -> (byte)0).build();
    public static final Set<UUID> SITTING_PLAYERS = new HashSet<UUID>();
    public static final Set<UUID> SYNCED_SITTING_PLAYERS = new HashSet<UUID>();

    public Personality() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.setupMessages();
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(this::registerKeyBindings));
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)PersonalityConfig.CLIENT_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        TrackedDataManager.INSTANCE.registerData(new ResourceLocation(MOD_ID, "climbing"), CLIMBING);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            PersonalityClient.TOGGLE_CRAWL.m_231514_((Object)((Boolean)PersonalityConfig.CLIENT.toggleCrawl.get()));
            PersonalityClient.TOGGLE_SIT.m_231514_((Object)((Boolean)PersonalityConfig.CLIENT.toggleSitting.get()));
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerKeyBindings(RegisterKeyMappingsEvent event) {
        PersonalityClient.CRAWL.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.IN_GAME);
        PersonalityClient.SIT.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.IN_GAME);
        event.register(PersonalityClient.CRAWL);
        event.register(PersonalityClient.SIT);
    }

    private void setupMessages() {
        int id = -1;
        CHANNEL.registerMessage(id++, MessageC2SCrawl.class, MessageC2SCrawl::serialize, MessageC2SCrawl::deserialize, MessageC2SCrawl::handle);
        CHANNEL.registerMessage(id++, MessageC2SSit.class, MessageC2SSit::serialize, MessageC2SSit::deserialize, MessageC2SSit::handle);
        CHANNEL.registerMessage(id++, MessageS2CSyncCrawl.class, MessageS2CSyncCrawl::serialize, MessageS2CSyncCrawl::deserialize, MessageS2CSyncCrawl::handle);
        CHANNEL.registerMessage(id, MessageS2CSyncSit.class, MessageS2CSyncSit::serialize, MessageS2CSyncSit::deserialize, MessageS2CSyncSit::handle);
    }
}

