/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.common.block.entity;

import de.cristelknight.doapi.DoApi;
import de.cristelknight.doapi.common.item.StandardItem;
import de.cristelknight.doapi.common.registry.DoApiBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class StandardBlockEntity
extends BlockEntity
implements BlockEntityTicker<StandardBlockEntity> {
    private ItemStack stack;

    public StandardBlockEntity(BlockPos blockPos, BlockState state) {
        super((BlockEntityType)DoApiBlockEntityTypes.STANDARD.get(), blockPos, state);
    }

    public void m_183515_(CompoundTag nbt) {
        CompoundTag tag = new CompoundTag();
        if (this.stack == null) {
            this.stack = ItemStack.f_41583_;
        }
        this.stack.m_41739_(tag);
        nbt.m_128365_("stack", (Tag)tag);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("stack"));
    }

    public void fromItem(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof StandardItem)) {
            throw new RuntimeException("[DoApi] False item for standard! At: " + this.m_58899_());
        }
        this.stack = new ItemStack((ItemLike)stack.m_41720_());
    }

    public Item getItem() {
        return this.stack == null ? Items.f_41852_ : this.stack.m_41720_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void tick(Level level, BlockPos pos, BlockState blockState, StandardBlockEntity blockEntity) {
        if (!level.m_5776_() && level.m_46467_() % 80L == 0L) {
            MobEffectInstance instance = StandardItem.getEffectInstanceOrNull(this.getItem());
            if (instance == null) {
                DoApi.LOGGER.error("MobEffectInstance for StandardBlock is null! At: " + pos);
                return;
            }
            level.m_6443_(Player.class, new AABB(pos).m_82400_(8.0), player -> true).forEach(player -> player.m_7292_(instance));
        }
    }
}

