/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.common.registry;

import de.cristelknight.doapi.Util;
import de.cristelknight.doapi.api.DoApiAPI;
import de.cristelknight.doapi.api.DoApiPlugin;
import de.cristelknight.doapi.common.block.entity.CabinetBlockEntity;
import de.cristelknight.doapi.common.block.entity.FlowerBoxBlockEntity;
import de.cristelknight.doapi.common.block.entity.FlowerPotBlockEntity;
import de.cristelknight.doapi.common.block.entity.SideBoardBlockEntity;
import de.cristelknight.doapi.common.block.entity.StandardBlockEntity;
import de.cristelknight.doapi.common.block.entity.StorageBlockEntity;
import de.cristelknight.doapi.common.registry.DoApiBlocks;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class DoApiBlockEntityTypes {
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"doapi", (ResourceKey)Registries.f_256922_);
    public static final RegistrySupplier<BlockEntityType<StorageBlockEntity>> STORAGE_ENTITY = DoApiBlockEntityTypes.create("storage", () -> BlockEntityType.Builder.m_155273_(StorageBlockEntity::new, (Block[])DoApiBlockEntityTypes.getBlocksForEntity()).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<StandardBlockEntity>> STANDARD = DoApiBlockEntityTypes.create("standard", () -> BlockEntityType.Builder.m_155273_(StandardBlockEntity::new, (Block[])new Block[]{DoApiBlocks.STANDARD.get(), DoApiBlocks.WALL_STANDARD.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CabinetBlockEntity>> CABINET_BLOCK_ENTITY = DoApiBlockEntityTypes.create("cabinet", () -> BlockEntityType.Builder.m_155273_(CabinetBlockEntity::new, (Block[])DoApiBlockEntityTypes.getBlocksForEntity()).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<SideBoardBlockEntity>> SIDEBOARD_BLOCK_ENTITY = DoApiBlockEntityTypes.create("sideboard", () -> BlockEntityType.Builder.m_155273_(SideBoardBlockEntity::new, (Block[])DoApiBlockEntityTypes.getBlocksForEntity()).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<FlowerBoxBlockEntity>> FLOWER_BOX_ENTITY = DoApiBlockEntityTypes.create("flower_box", () -> BlockEntityType.Builder.m_155273_(FlowerBoxBlockEntity::new, (Block[])DoApiBlockEntityTypes.getBlocksForEntity()).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<FlowerPotBlockEntity>> FLOWER_POT_ENTITY = DoApiBlockEntityTypes.create("flower_pot", () -> BlockEntityType.Builder.m_155273_(FlowerPotBlockEntity::new, (Block[])DoApiBlockEntityTypes.getBlocksForEntity()).m_58966_(null));

    private static Block[] getBlocksForEntity() {
        HashSet<Block> set = new HashSet<Block>();
        List<DoApiAPI> apis = Util.getApis(DoApiAPI.class, "doapi", DoApiPlugin.class);
        for (DoApiAPI api : apis) {
            api.registerBlocks(set);
        }
        return set.toArray(new Block[0]);
    }

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> create(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(path, type);
    }

    public static void init() {
        BLOCK_ENTITY_TYPES.register();
    }
}

