/*
 * Decompiled with CFR 0.152.
 */
package io.github.andrew6rant.dynamictrim.mixin.modernfix;

import com.bawnorton.mixinsquared.TargetHandler;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.andrew6rant.dynamictrim.resource.DynamicTrimLoader;
import io.github.andrew6rant.dynamictrim.util.mixin.ModernFixConditionChecker;
import io.github.andrew6rant.dynamictrim.util.mixin.annotation.AdvancedConditionalMixin;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@AdvancedConditionalMixin(checker=ModernFixConditionChecker.class)
@Mixin(value={ModelManager.class}, priority=1500)
public abstract class BakedModelManagerMixin {
    @Unique
    private static final Map<ResourceLocation, Resource> dynamicTrim$Overrides = new HashMap<ResourceLocation, Resource>();

    @TargetHandler(mixin="org.embeddedt.modernfix.common.mixin.perf.dynamic_resources.ModelManagerMixin", name="loadSingleBlockModel")
    @WrapOperation(method={"@MixinSquared:Handler"}, at={@At(value="INVOKE", target="net/minecraft/resource/ResourceManager.getResource(Lnet/minecraft/util/Identifier;)Ljava/util/Optional;")})
    private Optional<Resource> loadDynamicTrims(ResourceManager instance, ResourceLocation location, Operation<Optional<Resource>> original) {
        if (dynamicTrim$Overrides.containsKey(location)) {
            return Optional.of(dynamicTrim$Overrides.remove(location));
        }
        Optional resource = (Optional)original.call(new Object[]{instance, location});
        if (!DynamicTrimLoader.isTrimmable(location) || resource.isEmpty()) {
            return resource;
        }
        Map<ResourceLocation, Resource> toLoad = DynamicTrimLoader.generateResourceMapForSingleTrim(location, (Resource)resource.orElseThrow());
        Resource requested = toLoad.remove(location);
        dynamicTrim$Overrides.putAll(toLoad);
        return Optional.of(requested);
    }
}

