/*
 * Decompiled with CFR 0.152.
 */
package io.github.andrew6rant.dynamictrim.resource;

import io.github.andrew6rant.dynamictrim.DynamicTrimClient;
import io.github.andrew6rant.dynamictrim.json.JsonHelper;
import io.github.andrew6rant.dynamictrim.resource.OverrideResource;
import io.github.andrew6rant.dynamictrim.resource.TrimModelHelper;
import io.github.andrew6rant.dynamictrim.resource.TrimmableItem;
import io.github.andrew6rant.dynamictrim.resource.TrimmableResource;
import io.github.andrew6rant.dynamictrim.util.DebugHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;

public class DynamicTrimLoader {
    private static final Map<ResourceLocation, TrimmableItem> TRIMMABLE_ITEMS = new HashMap<ResourceLocation, TrimmableItem>();
    private static final Set<Supplier<Collection<TrimmableItem>>> CUSTOM = new HashSet<Supplier<Collection<TrimmableItem>>>();

    public static void addCustom(Supplier<Collection<TrimmableItem>> item) {
        CUSTOM.add(item);
    }

    private static String getArmourType(ArmorItem value) {
        return switch (value.m_40402_()) {
            default -> throw new IncompatibleClassChangeError();
            case EquipmentSlot.HEAD -> "helmet";
            case EquipmentSlot.CHEST -> "chestplate";
            case EquipmentSlot.LEGS -> "leggings";
            case EquipmentSlot.FEET -> "boots";
            case EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND -> null;
        };
    }

    private static Map<ResourceLocation, TrimmableItem> getTrimmableItems() {
        if (TRIMMABLE_ITEMS.isEmpty()) {
            BuiltInRegistries.f_257033_.forEach(item -> {
                if (!(item instanceof ArmorItem)) {
                    return;
                }
                ArmorItem armour = (ArmorItem)item;
                ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_(item);
                if (id.m_135827_().equals("betterend")) {
                    return;
                }
                String armourType = DynamicTrimLoader.getArmourType(armour);
                TrimmableItem trimmable = new TrimmableItem(armourType, id);
                if (armourType != null) {
                    TRIMMABLE_ITEMS.put(trimmable.resourceId(), trimmable);
                }
            });
            CUSTOM.forEach(supplier -> {
                Collection trimmableItems = (Collection)supplier.get();
                trimmableItems.forEach(item -> TRIMMABLE_ITEMS.put(item.resourceId(), (TrimmableItem)item));
            });
        }
        return TRIMMABLE_ITEMS;
    }

    public static boolean isTrimmable(ResourceLocation location) {
        return DynamicTrimLoader.getTrimmableItems().containsKey(location);
    }

    public static void loadDynamicTrims(Map<ResourceLocation, Resource> resourceMap) {
        for (TrimmableItem item : DynamicTrimLoader.getTrimmableItems().values()) {
            DynamicTrimLoader.loadTrims(item, resourceMap);
        }
    }

    public static Map<ResourceLocation, Resource> generateResourceMapForSingleTrim(ResourceLocation location, Resource original) {
        TrimmableItem item = DynamicTrimLoader.getTrimmableItems().get(location);
        if (item == null) {
            return Map.of(location, original);
        }
        Map resourceMap = (Map)Util.m_137469_(new HashMap(), map -> map.put(location, original));
        DynamicTrimLoader.loadTrims(item, resourceMap);
        return resourceMap;
    }

    private static void loadTrims(TrimmableItem item, Map<ResourceLocation, Resource> resourceMap) {
        ResourceLocation equipmentId = item.id();
        TrimmableResource equipmentResource = TrimModelHelper.buildResource(item, resourceMap);
        if (equipmentResource == null) {
            DynamicTrimClient.LOGGER.warn("Item %s's resource could not be built, skipping".formatted(equipmentId), new Object[0]);
            return;
        }
        resourceMap.put(item.resourceId(), equipmentResource.createDynamicResource());
        DebugHelper.createDebugFile("models", "%s.json".formatted(equipmentId), equipmentResource.modelString());
        equipmentResource.forEachOverride((override, material) -> {
            for (ResourceLocation patternId : TrimModelHelper.TEMPLATE_IDS) {
                OverrideResource overrideResource = equipmentResource.createOverrideResource(patternId, (String)material);
                resourceMap.put(overrideResource.modelId(), overrideResource.toResource(equipmentResource.resource().m_247173_()));
                DebugHelper.createDebugFile("models", "models/%s/trims/%s/%s_trim.json".formatted(equipmentResource.baseTextureId().m_135815_(), patternId.toString().replace(":", "-"), material), JsonHelper.toJsonString(overrideResource.modelResourceJson()));
            }
        });
    }
}

