/*
 * Decompiled with CFR 0.152.
 */
package io.github.andrew6rant.dynamictrim.resource;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.andrew6rant.dynamictrim.Compat;
import io.github.andrew6rant.dynamictrim.compat.AllTheTrimsCompat;
import io.github.andrew6rant.dynamictrim.mixin.accessor.PalettedPermutationsAtlasSourceAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.sources.PalettedPermutations;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class GroupPermutationsAtlasSource
extends PalettedPermutations {
    public static final Codec<GroupPermutationsAtlasSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.f_135803_).fieldOf("directories").forGetter(source -> ((PalettedPermutationsAtlasSourceAccessor)((Object)source)).getTextures()), (App)ResourceLocation.f_135803_.fieldOf("palette_key").forGetter(source -> ((PalettedPermutationsAtlasSourceAccessor)((Object)source)).getPaletteKey()), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)ResourceLocation.f_135803_).fieldOf("permutations").forGetter(source -> ((PalettedPermutationsAtlasSourceAccessor)((Object)source)).getPermutations())).apply((Applicative)instance, GroupPermutationsAtlasSource::new));
    public static SpriteSourceType TYPE;

    public static void bootstrap() {
    }

    private GroupPermutationsAtlasSource(List<ResourceLocation> directories, ResourceLocation paletteKey, Map<String, ResourceLocation> permutations) {
        super(new ArrayList<ResourceLocation>(directories), paletteKey, GroupPermutationsAtlasSource.evaluatePermutations(permutations));
    }

    private static Map<String, ResourceLocation> evaluatePermutations(Map<String, ResourceLocation> permutations) {
        if (Compat.isAllTheTrimsLoaded()) {
            return AllTheTrimsCompat.withBlankPermutation(permutations);
        }
        return permutations;
    }

    public void m_260891_(ResourceManager resourceManager, SpriteSource.Output regions) {
        ArrayList combinedTextures = new ArrayList();
        List<ResourceLocation> originalTextures = ((PalettedPermutationsAtlasSourceAccessor)((Object)this)).getTextures();
        for (ResourceLocation dir : originalTextures) {
            FileToIdConverter resourceFinder = new FileToIdConverter("textures/" + dir.m_135815_(), ".png");
            resourceFinder.m_247457_(resourceManager).forEach((identifier, resource) -> combinedTextures.add(resourceFinder.m_245273_(identifier).m_246208_(dir.m_135815_() + "/")));
        }
        originalTextures.clear();
        originalTextures.addAll(combinedTextures);
        if (Compat.isAllTheTrimsLoaded()) {
            AllTheTrimsCompat.generateAdditionalLayers(originalTextures);
        }
        super.m_260891_(resourceManager, regions);
    }

    public SpriteSourceType m_260850_() {
        return TYPE;
    }
}

