/*
 * Decompiled with CFR 0.152.
 */
package io.github.andrew6rant.dynamictrim.resource;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.github.andrew6rant.dynamictrim.DynamicTrimClient;
import io.github.andrew6rant.dynamictrim.extend.SmithingTemplateItemExtender;
import io.github.andrew6rant.dynamictrim.json.JsonHelper;
import io.github.andrew6rant.dynamictrim.resource.TrimmableItem;
import io.github.andrew6rant.dynamictrim.resource.TrimmableResource;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class TrimModelHelper {
    public static final List<ResourceLocation> TEMPLATE_IDS = new ArrayList<ResourceLocation>();

    public static TrimmableResource buildResource(TrimmableItem item, Map<ResourceLocation, Resource> lookupMap) {
        Resource resource = TrimModelHelper.getResource(item, lookupMap);
        if (resource == null) {
            return null;
        }
        JsonObject model = TrimModelHelper.getModel(resource);
        if (model == null) {
            return null;
        }
        JsonObject textures = TrimModelHelper.getTextures(model, item);
        if (textures == null) {
            return null;
        }
        String baseTexture = TrimModelHelper.getBaseTexture(textures, item);
        if (baseTexture == null) {
            return null;
        }
        JsonArray overrides = TrimModelHelper.getOverrides(model, item);
        if (overrides == null) {
            return null;
        }
        return new TrimmableResource(item, resource, model, textures, baseTexture, overrides);
    }

    private static Resource getResource(TrimmableItem item, Map<ResourceLocation, Resource> lookupMap) {
        Resource resource = lookupMap.get(item.resourceId());
        if (resource == null) {
            DynamicTrimClient.LOGGER.debug("Could not find resource " + String.valueOf(item.resourceId()) + " for item " + String.valueOf(item.id()) + ", skipping", new Object[0]);
            return null;
        }
        return resource;
    }

    private static JsonObject getModel(Resource resource) {
        JsonObject jsonObject;
        block8: {
            BufferedReader reader = resource.m_215508_();
            try {
                jsonObject = JsonHelper.fromJson(reader, JsonObject.class);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    DynamicTrimClient.LOGGER.debug("Could not read model file", e);
                    return null;
                }
            }
            reader.close();
        }
        return jsonObject;
    }

    private static JsonObject getTextures(JsonObject model, TrimmableItem item) {
        if (!model.has("textures")) {
            DynamicTrimClient.LOGGER.debug("Item " + String.valueOf(item.id()) + "'s model does not have a textures parameter, skipping", new Object[0]);
            return null;
        }
        return model.get("textures").getAsJsonObject();
    }

    private static String getBaseTexture(JsonObject textures, TrimmableItem item) {
        if (!textures.has("layer0")) {
            DynamicTrimClient.LOGGER.debug("Item " + String.valueOf(item.id()) + "'s model does not have a layer0 texture, skipping", new Object[0]);
            return null;
        }
        return textures.get("layer0").getAsString();
    }

    private static JsonArray getOverrides(JsonObject model, TrimmableItem item) {
        if (!model.has("overrides")) {
            DynamicTrimClient.LOGGER.debug("Item " + String.valueOf(item.id()) + "'s model does not have an overrides parameter, skipping", new Object[0]);
            return null;
        }
        return model.get("overrides").getAsJsonArray();
    }

    static {
        BuiltInRegistries.f_257033_.m_123024_().filter(item -> item instanceof SmithingTemplateItemExtender).map(item -> ((SmithingTemplateItemExtender)item).dynamicTrim$getPatternAssetId()).filter(Objects::nonNull).forEach(TEMPLATE_IDS::add);
    }
}

