/*
 * Decompiled with CFR 0.152.
 */
package io.github.andrew6rant.dynamictrim.resource;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.andrew6rant.dynamictrim.DynamicTrimClient;
import io.github.andrew6rant.dynamictrim.json.JsonHelper;
import io.github.andrew6rant.dynamictrim.resource.OverrideResource;
import io.github.andrew6rant.dynamictrim.resource.TrimModelHelper;
import io.github.andrew6rant.dynamictrim.resource.TrimmableItem;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public record TrimmableResource(TrimmableItem item, Resource resource, JsonObject model, JsonObject textures, String baseTexture, JsonArray overrides) {
    public String modelString() {
        return JsonHelper.toJsonString(this.model);
    }

    public void forEachOverride(BiConsumer<JsonObject, String> overrideMaterialConsumer) {
        for (JsonElement override : this.overrides) {
            if (!override.isJsonObject()) continue;
            JsonObject overrideJson = override.getAsJsonObject();
            String overrideModel = overrideJson.get("model").getAsString();
            if (overrideModel == null) {
                DynamicTrimClient.LOGGER.debug("Item " + String.valueOf(this.item.id()) + "'s model override does not have a model parameter, skipping", new Object[0]);
                continue;
            }
            String material = this.getMaterial(overrideModel);
            if (material == null) continue;
            overrideMaterialConsumer.accept(overrideJson, material);
        }
    }

    private String getMaterial(String overrideModel) {
        String material = StringUtils.substringBetween((String)overrideModel, (String)(this.baseTexture + "_"), (String)"_trim");
        if (material == null) {
            try {
                String modid = this.item.id().m_135827_();
                if (modid.equals("frostiful")) {
                    String[] segments = overrideModel.split("/");
                    material = segments[segments.length - 1];
                }
            }
            catch (Exception e) {
                DynamicTrimClient.LOGGER.debug("Can't parse frostiful override model " + overrideModel, e);
            }
            if (material == null) {
                DynamicTrimClient.LOGGER.debug("Can't find material for item " + String.valueOf(this.item.id()) + "'s model override: " + overrideModel + ", skipping", new Object[0]);
                return null;
            }
        }
        return material;
    }

    public Resource createDynamicResource() {
        JsonArray dynamicOverrides = new JsonArray();
        this.forEachOverride((override, material) -> {
            JsonObject predicate = override.getAsJsonObject("predicate");
            for (ResourceLocation patternId : TrimModelHelper.TEMPLATE_IDS) {
                String pattern = patternId.toString().replace(":", "-");
                JsonObject dynamicOverride = new JsonObject();
                dynamicOverride.addProperty("model", "%s:%s/trims/%s/%s_trim".formatted(this.baseTextureId().m_135827_(), this.baseTextureId().m_135815_(), pattern, material));
                JsonObject dynamicPredicate = predicate.deepCopy();
                dynamicPredicate.addProperty("trim_pattern", pattern);
                dynamicOverride.add("predicate", (JsonElement)dynamicPredicate);
                dynamicOverrides.add((JsonElement)dynamicOverride);
            }
        });
        this.model.add("overrides", (JsonElement)dynamicOverrides);
        return new Resource(this.resource.m_247173_(), () -> IOUtils.toInputStream((String)this.modelString(), (String)"UTF-8"));
    }

    public OverrideResource createOverrideResource(ResourceLocation patternId, String material) {
        JsonElement layerElement;
        String pattern = patternId.toString().replace(":", "-");
        JsonObject modelOverrideJson = new JsonObject();
        modelOverrideJson.addProperty("parent", this.model().get("parent").getAsString());
        JsonObject overrideTextures = new JsonObject();
        modelOverrideJson.add("textures", (JsonElement)overrideTextures);
        overrideTextures.addProperty("layer0", this.baseTexture);
        int layer = 0;
        while ((layerElement = this.textures().get("layer" + ++layer)) != null) {
            overrideTextures.addProperty("layer" + layer, layerElement.getAsString());
        }
        if (!material.equals("dynamic")) {
            ResourceLocation trimLayerTextureId = new ResourceLocation(this.baseTexture).m_247449_("trims/items/%s/%s_%s".formatted(this.item.type(), pattern, material));
            ResourceLocation asMinecraft = new ResourceLocation("minecraft", trimLayerTextureId.m_135815_());
            overrideTextures.addProperty("layer" + layer, asMinecraft.toString());
        } else {
            for (int i = 0; i < 8; ++i) {
                ResourceLocation trimLayerTextureId = new ResourceLocation(this.baseTexture()).m_247449_("trims/items/%s/%s_%s_%s".formatted(this.item.type(), pattern, i, material));
                ResourceLocation asMinecraft = new ResourceLocation("minecraft", trimLayerTextureId.m_135815_());
                overrideTextures.addProperty("layer" + (layer + i), asMinecraft.toString());
            }
        }
        ResourceLocation overrideResourceModelId = new ResourceLocation(this.item.id().m_135827_(), "models/%s/trims/%s/%s_trim.json".formatted(new ResourceLocation(this.baseTexture).m_135815_(), pattern, material));
        return new OverrideResource(overrideResourceModelId, modelOverrideJson);
    }

    public ResourceLocation baseTextureId() {
        return new ResourceLocation(this.baseTexture);
    }
}

