/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.excessive_building.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;
import net.yirmiri.excessive_building.datagen.EBItemTagProvider;
import org.jetbrains.annotations.NotNull;

public class PotBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty FILLED = BooleanProperty.m_61465_((String)"filled");
    private static final VoxelShape AABB = Shapes.m_83124_((VoxelShape)PotBlock.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)11.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0), Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0)});

    public PotBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return AABB;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter getter, List<Component> list, TooltipFlag flag) {
        super.m_5871_(stack, getter, list, flag);
        list.add(CommonComponents.f_237098_);
        list.add((Component)Component.m_237115_((String)"tooltip.block.interact_soil").m_130940_(ChatFormatting.GRAY));
        list.add((Component)CommonComponents.m_264333_().m_7220_((Component)Component.m_237115_((String)"tooltip.block.fill").m_130940_(ChatFormatting.BLUE)));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!level.f_46443_) {
            if (!((Boolean)state.m_61143_((Property)FILLED)).booleanValue() && itemstack.m_204117_(EBItemTagProvider.POT_SOILS)) {
                PotBlock.addFilling(state, level, pos);
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
            } else if (((Boolean)state.m_61143_((Property)FILLED)).booleanValue()) {
                PotBlock.removeFilling(state, level, pos);
                if (!player.m_7500_()) {
                    PotBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42329_));
                }
            } else {
                return InteractionResult.PASS;
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private static void addFilling(BlockState state, Level level, BlockPos pos) {
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(true)));
        level.m_5594_(null, pos, SoundEvents.f_144209_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void removeFilling(BlockState state, Level level, BlockPos pos) {
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(false)));
        level.m_5594_(null, pos, SoundEvents.f_144206_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction direction, IPlantable plantable) {
        return (Boolean)state.m_61143_((Property)FILLED);
    }

    public BlockState m_7417_(BlockState canSurvive, Direction direction, BlockState state, LevelAccessor accessor, BlockPos pos, BlockPos blockPos) {
        if (((Boolean)canSurvive.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            accessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)accessor));
        }
        return !canSurvive.m_60710_((LevelReader)accessor, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(canSurvive, direction, state, accessor, pos, blockPos);
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED, FILLED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level levelaccessor = ctx.m_43725_();
        BlockPos blockpos = ctx.m_8083_();
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_));
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult result, Projectile projectile) {
        BlockPos blockpos = result.m_82425_();
        if (!level.f_46443_ && projectile.m_142265_(level, blockpos) && projectile.m_6095_().m_204039_(EntityTypeTags.f_13124_)) {
            level.m_46953_(blockpos, true, (Entity)projectile);
        }
    }
}

