/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.excessive_building.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.yirmiri.excessive_building.block.PotBlock;
import net.yirmiri.excessive_building.register.EBBlocks;

public class EBBlockStateProvider
extends BlockStateProvider {
    public EBBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "excessive_building", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (DyeColor colours : DyeColor.values()) {
            this.simplePotBlockWithItem(EBBlocks.getDyedTerracottaPot(colours.m_41060_()), (ModelFile)this.potModel(colours.m_41065_() + "_terracotta_pot").texture("0", "block/" + colours.m_41065_() + "_terracotta_pot").texture("particle", "minecraft:block/" + colours.m_41065_() + "_terracotta"), (ModelFile)this.potModel(colours.m_41065_() + "_terracotta_pot_filled").texture("0", "block/" + colours.m_41065_() + "_terracotta_pot_filled").texture("particle", "minecraft:block/" + colours.m_41065_() + "_terracotta"));
        }
    }

    public ModelBuilder<?> potModel(String name) {
        return this.models().withExistingParent(name, "excessive_building:custom/template_pot");
    }

    public void simplePotBlockWithItem(Block block, ModelFile model, ModelFile modelFilled) {
        this.potBlock(block, model, modelFilled);
        this.simpleBlockItem(block, model);
    }

    public void potBlock(Block block, ModelFile normalModel, ModelFile modelFilled) {
        this.getVariantBuilder(block).partialState().with((Property)PotBlock.FILLED, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel(modelFilled)}).partialState().with((Property)PotBlock.FILLED, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel(normalModel)});
    }

    private void blockWithItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(this.name(signBlock), texture);
        this.hangingSignBlock(signBlock, wallSignBlock, (ModelFile)sign);
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ModelFile sign) {
        this.simpleBlock(signBlock, sign);
        this.simpleBlock(wallSignBlock, sign);
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }
}

