/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.excessive_building.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.yirmiri.excessive_building.compat.EBCompatRegistries;
import net.yirmiri.excessive_building.datagen.EBBannerTagProvider;
import net.yirmiri.excessive_building.datagen.EBBlockStateProvider;
import net.yirmiri.excessive_building.datagen.EBBlockTagProvider;
import net.yirmiri.excessive_building.datagen.EBItemModelProvider;
import net.yirmiri.excessive_building.datagen.EBItemTagProvider;
import net.yirmiri.excessive_building.datagen.EBRecipeProvider;
import net.yirmiri.excessive_building.datagen.EBWorldGenProvider;
import net.yirmiri.excessive_building.datagen.loot.EBGlobalLootModifiersProvider;

@Mod.EventBusSubscriber(modid="excessive_building", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EBDataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new EBRecipeProvider(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new EBBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new EBItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new EBGlobalLootModifiersProvider(packOutput));
        EBBlockTagProvider blockTagGenerator = (EBBlockTagProvider)generator.addProvider(event.includeServer(), (DataProvider)new EBBlockTagProvider(packOutput, lookupProvider, existingFileHelper));
        EBBannerTagProvider bannerTagProvider = (EBBannerTagProvider)generator.addProvider(event.includeServer(), (DataProvider)new EBBannerTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new EBItemTagProvider(packOutput, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
        if (EBCompatRegistries.terrablender) {
            generator.addProvider(event.includeServer(), (DataProvider)new EBWorldGenProvider(packOutput, lookupProvider));
        }
    }
}

